/***************************************************************************
                            KURIFilterData.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KURIFILTERDATA_H
#define KURIFILTERDATA_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This is a basic message object used for exchanging filtering
 information between the filter plugins and the application
 whenever the application requires more information about the
 URI than just a filtered version of it.  Any application can
 create an instance of this class and send it to @ref KURIFilter
 to have the filter plugins fill the necessary information.

 The above code should yield the following output:
 <pre>
   URI: kde.org
   Filtered URI: http://kde.org
   URI Type: 0            <== means NET_PROTOCOL
   Was Filtered: 1        <== means the URL was successfully filtered
 </pre>

 @short A message object for exchanging filtering URI info.

*/
@class KURL; 

@interface  KURIFilterData : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Default constructor.

 Creates a URIFilterData object.
     
*/
- init;

/** 
 Creates a URIFilterData object from the given URL.

*/
- initWithURL: (KURL*)url;

/** 
 Creates a URIFilterData object from the given string.

*/
- initWithText: (NSString *)url;

/** 
 Copy constructor.

 Creates a URIFilterData object from another
 URI filter data object.

*/
- copyWithZone: (NSZone *) zone;

/** 
 Destructor.
     
*/
- (void) dealloc;

/** 
 This method has been deprecated and will always return
 TRUE.  You should instead use the result from the
 @ref -[KURIFilter filterURI] calls.

     
*/
- (BOOL) hasBeenFiltered;

/** 
 Returns the filtered or the original URL.

 This function returns the filtered url if one
 of the plugins sucessfully filtered the original
 URL.  Otherwise, it returns the original URL.
 See @ref  #--hasBeenFiltered and

*/
- (KURL*) uri;

/** 
 Returns an error message.

 This functions returns the error message set
 by the plugin whenever the uri type is set to
 -[KURIFilterData ERROR].  Otherwise, it returns
 a -[QString null].

*/
- (NSString *) errorMsg;

/** 
 Returns the URI type.

 This method always returns -[KURIFilterData UNKNOWN]if the given URL was not filtered.
     
*/
- (int) uriType;

/** 
 Sets the URL to be filtered.

 Use this function to set the string to be
 filtered when you construct an empty filter
 object.

*/
- setData: (NSString *)url;

/** 
 Same as above except the argument is a URL.

 Use this function to set the string to be
 filtered when you construct an empty filter
 object.

*/
- setDataFromURL: (KURL*)url;

/** 
 Sets the absolute path to be used whenever the supplied
 data is a relative local URL.

 NOTE: This function works only for a local resource and
 expects the absolute path to the relative URL set in this
 meta object.  If you are extracting the absolute path from
 a KURL object, make sure you always set the argument below
 using -[KURL path] instead of -[KURL url] so that "file:/"
 would not be appended! Otherwise, the filter might not be
 able to make correct determination whether the relative URL
 locally exists!

*/
- (BOOL) setAbsolutePath: (NSString *)arg1;

/** 
 Returns the absolute path if one has already been set.
     
*/
- (NSString *) absolutePath;

/** 
 Returns true if the supplied data has an absolute path.
     
*/
- (BOOL) hasAbsolutePath;

/** 
 Returns the command line options and arguments for a
 local resource when present.

*/
- (NSString *) argsAndOptions;

/** 
 Returns true if the current data is a local resource with
 command line options and arguments.
     
*/
- (BOOL) hasArgsAndOptions;

/** 
 Returns the name of the icon that matches
 the current filtered URL.

 NOTE that this function will return a NULL
 string by default and when no associated icon
 is found.

*/
- (NSString *) iconName;

/** 
 Initializes the KURIFilterData on construction.
     
*/
- init: (KURL*)url;
- init;
+ (int) NET_PROTOCOL;
+ (int) LOCAL_FILE;
+ (int) LOCAL_DIR;
+ (int) EXECUTABLE;
+ (int) HELP;
+ (int) SHELL;
+ (int) BLOCKED;
+ (int) ERROR;
+ (int) UNKNOWN;
@end

#endif
