/***************************************************************************
                            KMultipleDrag.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KMULTIPLEDRAG_H
#define KMULTIPLEDRAG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QDragObject.h>

/**

 This class makes it easy for applications to provide a drag object
 (for drag-n-drop or for clipboard) that has several representations
 of the same data, under different formats.

 Instead of creating a specific class for each case (as would otherwise
 be necessary), you can simply create independent drag objects (e.g.
 a QImageDrag object and a KURLDrag object), and bundle them together
 using KMultipleDrag.

 Sample code for this:

 KMultipleDrag *drag = new KMultipleDrag( parentWidget );
 -[drag addDragObject]( new QImageDrag( someQImage, 0L ) );
 -[drag addDragObject]( -[KURLDrag newDrag]( someKURL, 0L ) );
 -[drag drag];

 Note that the drag objects added to the multiple drag become owned by it.
 For that reason their parent should be 0L.

 @author David Faure <david@mandrakesoft.com>
 
 @short 
 This class makes it easy for applications to provide a drag object
 (for drag-n-drop or for clipboard) that has several representations
 of the same data, under different formats.
*/
@interface KMultipleDrag : QDragObject 
- initWithWidget: (QWidget *)dragSource name: (NSString *)name;
- init;

/** 
 Call this to add each underlying drag object to the multipledrag.
     
*/
- addDragObject: (QDragObject*)dragObject;
- (QByteArray*) encodedData: (NSString *)mime;
- (NSString *) format: (int)i;
@end

/** Override these methods in subclasses of KMultipleDrag to customise event handling behaviour */
@protocol KMultipleDragEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
