/***************************************************************************
                            KFilterDev.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILTERDEV_H
#define KFILTERDEV_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QIODevice.h>

/**

 A class for reading and writing compressed data onto a device
 (e.g. file, but other usages are possible, like a buffer or a socket)

 To simply read/write compressed files, see @ref deviceForFile.

 @author David Faure <faure@kde.org>
 
 @short 
 A class for reading and writing compressed data onto a device
 (e.
*/
@class KFilterBase;
@class QFile;

@interface KFilterDev : QIODevice 

/** 
 Constructs a KFilterDev for a given filter (e.g. gzip, bzip2 etc.)

*/
- initWithFilterBase: (KFilterBase*)filter autodeleteFilterBase: (BOOL)autodeleteFilterBase;
- initWithFilterBase: (KFilterBase*)filter ;

/** 
 Destructs the KFilterDev.
     
*/
- (void) dealloc;
- (BOOL) open: (int)mode;
- close;
- flush;

/** 
 For writing gzip compressed files only:
 set the name of the original file, to be used in the gzip header.
     
*/
- setOrigFileName: (NSString *)fileName;
- (int) size;
- (int) at;

/** 
 That one can be quite slow, when going back. Use with care.
     
*/
- (BOOL) at: (int)arg1;
- (BOOL) atEnd;
- (long) readBlock: (NSString *)data maxlen: (long)maxlen;
- (long) writeBlock: (NSString *)data len: (long)len;
- (int) getch;
- (int) putch: (int)arg1;
- (int) ungetch: (int)arg1;

/** 
 Call this to create the appropriate filter device for @p base
 working on @p file . The returned QIODevice has to be deleted
 after using.

 To be removed in KDE 3.0
     
*/
+ (QIODevice*) createFilterDevice: (KFilterBase*)base file: (QFile*)file;

/** 
 Creates an i/o device that is able to read from @p fileName,
 whether it's compressed or not. Available compression filters
 (gzip/bzip2 etc.) will automatically be used.

 The compression filter to be used is determined from the @p fileName
 if @p mimetype is empty. Pass "application/x-gzip" or "application/x-bzip2"
 to force the corresponding decompression filter, if available.

 Warning: application/x-bzip2 may not be available.
 In that case a QFile opened on the compressed data will be returned !
 Use -[KFilterBase findFilterByMimeType]and code similar to what
 deviceForFile is doing, to better control what's happening.

 The returned QIODevice has to be deleted after using.
     
*/
+ (QIODevice*) deviceForFile: (NSString *)fileName mimetype: (NSString *)mimetype forceFilter: (BOOL)forceFilter;
+ (QIODevice*) deviceForFile: (NSString *)fileName ;
@end

#endif
