/***************************************************************************
                            KDirOperator.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDIROPERATOR_H
#define KDIROPERATOR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 This widget works as a network transparent filebrowser. You specify a URL
 to display and this url will be loaded via @ref KDirLister. The user can
 browse through directories, highlight and select files, delete or rename
 files.

 It supports different views, e.g. a detailed view (see @ref KFileDetailView),
 a simple icon view (see @ref KFileIconView), a combination of two views,
 separating directories and files (@ref KCombiView).

 Additionally, a preview view is available (see @ref KFilePreview), which can
 show either a simple or detailed view and additionally a preview widget
 (see @ref -setPreviewWidget). @ref KImageFilePreview is one implementation
 of a preview widget, that displays previews for all supported filetypes
 utilizing -[KIO PreviewJob].

 Currently, those classes don't support Drag&Drop out of the box -- there
 you have to use your own view-classes. You can use some DnD-aware views
 from Bjrn Sahlstrm <bjorn@kbear.org> until they will be integrated
 into this library. See http://master.kde.org/~pfeiffer/DnD-classes.tar.gz

 This widget is the one used in the KFileDialog.

 Basic usage is like this:
 <pre>
   KDirOperator *op = new KDirOperator( KURL( "file:/home/gis" ), this );
   // some signals you might be interested in
   connect(op, SIGNAL(updateInformation(int, int)),
           SLOT(updateStatusLine(int, int)));
   connect(op, SIGNAL(urlEntered(const KURL&)),
           SLOT(urlEntered(const KURL&)));
   connect(op, SIGNAL(fileHighlighted(const KFileItem *)),
           SLOT(fileHighlighted(const KFileItem *)));
   connect(op, SIGNAL(fileSelected(const KFileItem *)),
           SLOT(fileSelected(const KFileItem *)));
   connect(op, SIGNAL(-finishedLoading),
           SLOT(-slotLoadingFinished));

   -[op readConfig]( -[KGlobal config], "Your KDiroperator ConfigGroup" );
   -[op setView](-[KFile Default]);
 </pre>

 This will create a childwidget of 'this' showing the directory contents
 of /home/gis in the default-view. The view is determined by the -readConfig
 call, which will read the KDirOperator settings, the user left your program
 with (and which you saved with -[op writeConfig]).

 @author Stephan Kulow <coolo@kde.org>, Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A widget for displaying files and browsing directories.

*/
@class DeleteJob; 
@class KActionCollection; 
@class KCompletion; 
@class KConfig; 
@class KFileItem; 
@class KFileReader; 
@class KFileView; 
@class KFileViewItem; 
@class KProgress; 
@class KURL; 
@class parse; 

@class KDirLister; 

@interface KDirOperator : QWidget 

/** 
 Constructs the KDirOperator with no initial view. As the views are
 configurable, call @ref -readConfig to load the user's configuration
 and then @ref setView to explicitly set a view.

 This constructor doesn't start loading the url, @ref setView will do it.
     
*/
- initWithURL: (KURL*)urlName parent: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Destroys the KDirOperator.
     
*/
- (void) dealloc;

/** 
 Enables/disables showing hidden files.
     
*/
- setShowHiddenFiles: (BOOL)s;

/** 

*/
- (BOOL) showHiddenFiles;

/** 
 Stops loading immediately. You don't need to call this, usually.
     
*/
- close;

/** 
 Sets a filter like "*.cpp *.h *.o". Only files matching that filter
 will be shown. Call @ref -updateDir to apply it.

*/
- setNameFilter: (NSString *)filter;

/** 

*/
- (NSString *) nameFilter;

/** 
 Sets a list of mimetypes as filter. Only files of those mimetypes
 will be shown.

 Example:
 <pre>
 QStringList filter;
 filter << "text/html" << "image/png" << "inode/directory";
 -[dirOperator setMimefilter]( filter );
 </pre>

 Node: Without the mimetype inode/directory, only files would be shown.

*/
- setMimeFilter: (NSArray *)mimetypes;

/** 

*/
- (NSArray *) mimeFilter;

/** 
 Clears both the namefilter and mimetype filter, so that all files and
 directories will be shown.

*/
- clearFilter;

/** 

*/
- (KURL*) url;

/** 
 Sets a new url to list.

*/
- setURL: (KURL*)url clearforward: (BOOL)clearforward;

/** 
 Clears the current selection and attempts to set @p filename
 the current file. filename is just the name, no path or url.
     
*/
- setCurrentItem: (NSString *)filename;

/** 
 Sets a new KFileView to be used for showing and browsing files.
 Note: this will read the current @ref -url to fill the view.

*/
- setView: (KFileView*)view;

/** 

*/
- (KFileView*) view;

/** 
 Returns the widget of the current view. 0L if there is no view/widget.
 (KFileView itself is not a widget.)
     
*/
- (QWidget*) viewWidget;

/** 
 Sets one of the predefined fileviews

*/
- setPredefinedView: (int)view;

/** 
 Sets the way to sort files and directories.
     
*/
- setSorting: (int)arg1;

/** 

*/
- (int) sorting;

/** 

*/
- (BOOL) isRoot;

/** 

*/
- (KDirLister*) dirLister;

/** 

*/
- (KProgress*) progressBar;

/** 
 Sets the listing/selection mode for the views, an OR'ed combination of

 You cannot mix File and Files of course, as the former means
 single-selection mode, the latter multi-selection.
     
*/
- setMode: (int)m;

/** 

*/
- (int) mode;

/** 
 Sets a preview-widget to be shown next to the file-view.
 The ownership of @p w is transferred to KDirOperator, so don't
 delete it yourself!
     
*/
- setPreviewWidget: (QWidget *)w;

/** 

*/
- (NSArray *) selectedItems;

/** 

*/
- (BOOL) isSelected: (KFileItem*)item;

/** 

*/
- (int) numDirs;

/** 

*/
- (int) numFiles;

/** 

*/
- (KCompletion*) completionObject;

/** 

*/
- (KCompletion*) dirCompletionObject;

/** 
 an accessor to a collection of all available Actions. The actions
 are static, they will be there all the time (no need to connect to
 the signals -[KActionCollection inserted] or -removed.

 There are the following actions:

 The short and detailed view are in an exclusive group. The sort-by
 actions are in an exclusive group as well. Also the "separate dirs",
 "preview" and "single" actions are in an exclusive group.

 You can e.g. use
 <pre>-actionCollection->action( "up" )->plug( someToolBar );</pre>
 to add a button into a toolbar, which makes the dirOperator change to
 its parent directory.

*/
- (KActionCollection*) actionCollection;

/** 
 Reads the default settings for a view, i.e. the default -[KFile FileView].
 Also reads the sorting and whether hidden files should be shown.
 Note: the default view will not be set - you have to call
 <pre>
 setView( -[KFile Default])
 </pre>
 to apply it.

*/
- readConfig: (KConfig*)arg1 group: (NSString *)group;
- readConfig: (KConfig*)arg1 ;

/** 
 Saves the current settings like sorting, simple or detailed view.

*/
- writeConfig: (KConfig*)arg1 group: (NSString *)group;
- writeConfig: (KConfig*)arg1 ;

/** 
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 The default is false, set it to true if you don't want files selected
 with single click.
     
*/
- setOnlyDoubleClickSelectsFiles: (BOOL)enable;

/** 

*/
- (BOOL) onlyDoubleClickSelectsFiles;

/** 
 Creates the given directory/url. If it is a relative path,
 it will be completed with the current directory.
 If enterDirectory is true, the directory will be entered after a
 successful operation. If unsuccessful, a messagebox will be presented
 to the user.

*/
- (BOOL) mkdir: (NSString *)directory enterDirectory: (BOOL)enterDirectory;
- (BOOL) mkdir: (NSString *)directory ;

/** 
 Starts and returns a @ref -[KIO DeleteJob]to delete the given @p items.

*/
- (DeleteJob*) del: (NSArray *)items ask: (BOOL)ask showProgress: (BOOL)showProgress;
- (DeleteJob*) del: (NSArray *)items ;

/** 
 Clears the forward and backward history.
     
*/
- clearHistory;

/** 
 When going up in the directory hierarchy, KDirOperator can highlight
 the directory that was just left.

 I.e. when you go from /home/gis/src to /home/gis, the item "src" will
 be made the current item.

 Default is off.
     
*/
- setEnableDirHighlighting: (BOOL)enable;

/** 

 Default is false.
     
*/
- (BOOL) dirHighlighting;

/** 

*/
- (BOOL) dirOnlyMode;

/** 
 Goes one step back in the history and opens that url.
     
*/
- back;

/** 
 Goes one step forward in the history and opens that url.
     
*/
- forward;

/** 
 Enters the home directory.
     
*/
- home;

/** 
 Goes one directory up from the current url.
     
*/
- cdUp;

/** 
 to update the view after changing the settings
     
*/
- updateDir;

/** 
 Re-reads the current url.
     
*/
- rereadDir;

/** 
 Opens a dialog to create a new directory.
     
*/
- mkdir;

/** 
 Deletes the currently selected files/directories.
     
*/
- deleteSelected;

/** 
 Enables/disables actions that are selection dependent. Call this e.g.
 when you are about to show a popup menu using some of KDirOperators
 actions.
     
*/
- updateSelectionDependentActions;

/** 
 Tries to complete the given string (only completes files).
     
*/
- (NSString *) makeCompletion: (NSString *)arg1;

/** 
 Tries to complete the given string (only completes directores).
     
*/
- (NSString *) makeDirCompletion: (NSString *)arg1;
+ (BOOL) dirOnlyMode: (unsigned int)mode;

/** 
 A view factory for creating predefined fileviews. Called internally by @ref  #-setView
 , but you can also call it directly. Reimplement this if you depend on self defined fileviews.

*/
- (KFileView*) createView: (QWidget *)parent view: (int)view;

/** 
 Sets a custom KFileReader to list directories.
     
*/
- setDirLister: (KDirLister*)lister;

/** 
 Sets up all the actions. Called from the constructor, you usually
 better not call this.
     
*/
- setupActions;

/** 
 Updates the sorting-related actions to comply with the current sorting

*/
- updateSortActions;

/** 
 Updates the view-related actions to comply with the current
 -[KFile FileView]
*/
- updateViewActions;

/** 
 Sets up the context-menu with all the necessary actions. Called from the
 constructor, you usually don't need to call this.
     
*/
- setupMenu;

/** 
 Synchronizes the completion objects with the entries of the
 currently listed url.

 Automatically called from @ref -makeCompletion and
 @ref -makeDirCompletion
     
*/
- prepareCompletionObjects;

/** 
 Checks if there support from @ref -[KIO PreviewJob]for the currently
 shown files, taking @ref -mimeFilter and @ref -nameFilter into account
 Enables/disables the preview-action accordingly.
     
*/
- (BOOL) checkPreviewSupport;

/** 
 Restores the normal cursor after showing the busy-cursor. Also hides
 the progressbar.
     
*/
- resetCursor;

/** 
 Called after @ref -setURL to load the directory, update the history,
 etc.
     
*/
- pathChanged;

/** 
 Adds a new list of KFileItems to the view
 (coming from KDirLister)
     
*/
- insertNewFiles: (NSArray *)newone;

/** 
 Removes the given KFileItem item from the view (usually called from
 KDirLister).
     
*/
- itemDeleted: (KFileItem*)arg1;

/** 
 Enters the directory specified by the given @p item.
     
*/
- selectDir: (KFileItem*)item;

/** 
 Emits fileSelected( item )
     
*/
- selectFile: (KFileItem*)item;

/** 
 Emits fileHighlighted( i )
     
*/
- highlightFile: (KFileItem*)i;

/** 
 Called upon right-click to activate the popupmenu.
     
*/
- activatedMenu: (KFileItem*)arg1 pos: (QPoint*)pos;

/** 
 Changes sorting to sort by name
     
*/
- sortByName;

/** 
 Changes sorting to sort by size
     
*/
- sortBySize;

/** 
 Changes sorting to sort by date
     
*/
- sortByDate;

/** 
 Changes sorting to reverse sorting
     
*/
- sortReversed;

/** 
 Toggles showing directories first / having them sorted like files.
     
*/
- toggleDirsFirst;

/** 
 Toggles case sensitive / case insensitive sorting
     
*/
- toggleIgnoreCase;

/** 
 Tries to make the given @p match as current item in the view and emits
 completion( match )
     
*/
- slotCompletionMatch: (NSString *)match;
@end

/** Override these methods in subclasses of KDirOperator to customise event handling behaviour */
@protocol KDirOperatorEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;

/** 

     
*/
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
