/***************************************************************************
                            KDataToolInfo.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDATATOOLINFO_H
#define KDATATOOLINFO_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This is a convenience class for @ref KService. You can use it if you have
 a KService describing a KDataTool. In this case the KDataToolInfo class
 is more convenient to work with.

 Especially useful is the method @ref  #-createTool which creates the datatool
 described by the service.
 
 @short 
 This is a convenience class for @ref KService.
*/
@class KDataTool; 
@class KInstance; 
@class QObject;
@class QPixmap; 

@interface  KDataToolInfo : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Create an invalid KDataToolInfo.
     
*/
- init;

/** 
 Create a valid KDataToolInfo.
     
*/
//- initWithServicePtr: (KServicePtr*)service instance: (KInstance*)instance;

/** 
 Copy constructor.
     
*/
- copyWithZone: (NSZone *) zone;

/** 

*/
- (NSString *) dataType;

/** 

 The mimetypes are only used if the @ref  #-dataType can be used to store
 different mimetypes. For example in a "QString" you could save "text/plain"
 or "text/html" or "text/xml".
     
*/
- (NSArray *) mimeTypes;

/** 

*/
- (BOOL) isReadOnly;

/** 

     
*/
- (QPixmap*) icon;

/** 

     
*/
- (QPixmap*) miniIcon;

/** 

*/
- (NSString *) iconName;

/** 

 This list comes from the Comment field of the tool's desktop file
 (so that it can be translated).

 Each of the strings returned corresponds to a string in the list returned by
 @ref  #-commands.
     
*/
- (NSArray *) userCommands;

/** 

 This list comes from the Commands field of the tool's desktop file.

 Each of the strings returned corresponds to a string in the list returned by
 @ref  #-userCommands.
     
*/
- (NSArray *) commands;

/** 
 Creates the data tool described by this KDataToolInfo.

*/
- (KDataTool*) createTool: (QObject *)parent name: (NSString *)name;
- (KDataTool*) createTool;
//- (KService_Ptr*) service;
- (KInstance*) instance;

/** 
 A DataToolInfo may be invalid if the @ref KService passed to its constructor does
 not feature the service type "KDataTool".
     
*/
- (BOOL) isValid;
@end

#endif
