/***************************************************************************
                            KCompletion.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOMPLETION_H
#define KCOMPLETION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 This class offers easy use of "auto-completion", "manual-completion" or
 "shell completion" on QString objects. A common use is completing filenames
 or URLs (see @ref -KURLCompletion).
 But it is not limited to URL-completion -- everything should be completable!
 The user should be able to complete email-addresses, telephone-numbers,
 commands, SQL queries, ...
 Every time your program knows what the user can type into an edit-field, you
 should offer completion. With KCompletion, this is very easy, and if you are
 using a line edit widget (@ref KLineEdit), it is even more easy.
 Basically, you tell a KCompletion object what strings should be completable
 and whenever completion should be invoked, you call @ref -makeCompletion.
 KLineEdit and (an editable) KComboBox even do this automatically for you.

 KCompletion offers the completed string via the signal @ref -match and
 all matching strings (when the result is ambiguous) via the method
 @ref -allMatches.

 Notice: auto-completion, shell completion and manual completion work
         slightly differently:

 You don't have to worry much about that though, KCompletion handles
 that for you, according to the setting @ref -setCompletionMode.
 The default setting is globally configured by the user and read
 from @ref -[KGlobalSettings completionMode].

 A short example:
 <pre>
 KCompletion completion;
 completion.setOrder( -[KCompletion Sorted]);
 completion.addItem( "pfeiffer@kde.org" );
 completion.addItem( "coolo@kde.org" );
 completion.addItem( "carpdjih@sp.zrz.tu-berlin.de" );
 completion.addItem( "carp@cs.tu-berlin.de" );

 cout << completion.makeCompletion( "ca" ).-latin1 << endl;
 </pre>
 In shell-completion-mode, this will be "carp"; in auto-completion-
 mode it will be "carp@cs.tu-berlin.de", as that is alphabetically
 smaller.
 If setOrder was set to Insertion, "carpdjih@sp.zrz.tu-berlin.de"
 would be completed in auto-completion-mode, as that was inserted before
 "carp@cs.tu-berlin.de".

 You can dynamically update the completable items by removing and adding them
 whenever you want.
 For advanced usage, you could even use multiple KCompletion objects. E.g.
 imagine an editor like kwrite with multiple open files. You could store
 items of each file in a different KCompletion object, so that you know (and
 tell the user) where a completion comes from.

 Note: KCompletion does not work with strings that contain 0x0 characters
       (unicode nul), as this is used internally as a delimiter.

 You may inherit from KCompletion and override @ref -makeCompletion in
 special cases (like reading directories/urls and then supplying the
 contents to KCompletion, as KURLCompletion does), but generally, this is
 not necessary.

 @author Carsten Pfeiffer <pfeiffer@kde.org>

 @version $Id: KCompletion.h,v 1.3 2002/03/15 02:12:19 rdale Exp $
 
 @short A generic class for completing QStrings.
*/
@class KCompletionMatches; 

@interface KCompletion : QObject 

/** 
 Constructor, nothing special here :)
     
*/
- init;

/** 
 Destructor, nothing special here, either.
     
*/
- (void) dealloc;

/** 
 Attempts to find an item in the list of available completions,
 that begins with @p string. Will either return the first matching item
 (if there is more than one match) or -[QString null], if no match was
 found.

 In the latter case, a sound will be issued, depending on
 @ref -isSoundsEnabled.
 If a match was found, it will also be emitted via the signal
 @ref -match.

 If this is called twice or more often with the same string while no
 items were added or removed in the meantime, all available completions
 will be emitted via the signal @ref -matches.
 This happens only in shell-completion-mode.

*/
- (NSString *) makeCompletion: (NSString *)string;

/** 

*/
- (NSArray *) substringCompletion: (NSString *)string;

/** 

*/
- (NSString *) previousMatch;

/** 

*/
- (NSString *) nextMatch;

/** 

*/
- (NSString *) lastMatch;

/** 
 Returns a list of all items inserted into KCompletion. This is useful
 if you need to save the state of a KCompletion object and restore it
 later.

 Important note: when @ref -order == Weighted, then every item in the
 stringlist has its weight appended, delimited by a colon. E.g. an item
 "www.kde.org" might look like "www.kde.org:4", where 4 is the weight.

 This is necessary so that you can save the items along with its
 weighting on disk and load them back with @ref -setItems, restoring its
 weight as well. If you really don't want the appended weightings, call
 @ref setOrder( -[KCompletion Insertion])
 before calling -items.

*/
- (NSArray *) items;

/** 
 Sets the completion mode to Auto/Manual, Shell or None.
 If you don't set the mode explicitly, the global default value
 -[KGlobalSettings completionMode] is used.
 @ref -[KGlobalSettings CompletionNone]disables completion.

*/
- setCompletionMode: (int)mode;

/** 

*/
- (int) completionMode;

/** 
 KCompletion offers three different ways in which it offers its items:

 Choosing weighted makes KCompletion perform an implicit weighting based
 on how often an item is inserted. Imagine a web browser with a location
 bar, where the user enters URLs. The more often a URL is entered, the
 higher priority it gets.

 Note: Setting the order to sorted only affects new inserted items,
 already existing items will stay in the current order. So you probably
 want to call setOrder( Sorted ) before inserting items, when you want
 everything sorted.

 Default is insertion order

*/
- setOrder: (int)order;

/** 

*/
- (int) order;

/** 
 Setting this to true makes KCompletion behave case insensitively.
 E.g. makeCompletion( "CA" ); might return "carp@cs.tu-berlin.de".
 Default is false (case sensitive).

*/
- setIgnoreCase: (BOOL)ignoreCase;

/** 

*/
- (BOOL) ignoreCase;

/** 

*/
- (NSArray *) allMatches;

/** 

*/
- (NSArray *) allMatches: (NSString *)string;

/** 

*/
//- (KCompletionMatches) allWeightedMatches;

/** 

*/
//- (KCompletionMatches) allWeightedMatches: (NSString *)string;

/** 
 Enables/disables playing a sound when

 For playing the sounds, @ref -KNotifyClient is used.

*/
- setEnableSounds: (BOOL)enable;

/** 
 Tells you whether KCompletion will play sounds on certain occasions.
 Default is enabled

*/
- (BOOL) isSoundsEnabled;

/** 

*/
- (BOOL) hasMultipleMatches;

/** 

*/
- enableSounds;

/** 

*/
- disableSounds;

/** 
 Attempts to complete "string" and emits the completion via @ref -match.
 Same as @ref -makeCompletion (just as a slot).

*/
- slotMakeCompletion: (NSString *)string;

/** 
 Searches the previous matching item and emits it via @ref -match
 Same as @ref -previousMatch (just as a slot).

*/
- slotPreviousMatch;

/** 
 Searches the next matching item and emits it via @ref -match
 Same as @ref -nextMatch (just as a slot).

*/
- slotNextMatch;

/** 
 Inserts @p items into the list of possible completions.
 Does the same as @ref -setItems, but does not call @ref -clear before.
     
*/
- insertItems: (NSArray *)items;

/** 
 Sets the list of items available for completion. Removes all previous
 items.

 Notice: when -order == Weighted, then the weighting is looked up for
 every item in the stringlist. Every item should have ":number" appended,
 where number is an unsigned integer, specifying the weighting.

 If you don't like this, call
 setOrder( -[KCompletion Insertion])
 before calling -setItems.

*/
- setItems: (NSArray *)arg1;

/** 
 Adds an item to the list of available completions.
 Resets the current item-state (@ref -previousMatch and @ref -nextMatch
 won't work anymore).
     
*/
- addTextItem: (NSString *)arg1;

/** 
 Adds an item to the list of available completions.
 Resets the current item-state (@ref -previousMatch and @ref -nextMatch
 won't work anymore).

 Sets the weighting of the item to @p weight or adds it to the current
 weighting if the item is already available. The weight has to be greater
 than 1 to take effect (default weight is 1).
     
*/
- addTextItem: (NSString *)arg1 weight: (unsigned int)weight;

/** 
 Removes an item from the list of available completions.
 Resets the current item-state (@ref -previousMatch and @ref -nextMatch
 won't work anymore).
     
*/
- removeTextItem: (NSString *)arg1;

/** 
 Removes all inserted items.
     
*/
- clear;

/** 
 This method is called after a completion is found and before the
 matching string is emitted. You can override this method to modify the
 string that will be emitted.
 This is necessary e.g. in @ref -KURLCompletion, where files with spaces
 in their names are shown escaped ("filename\ with\ spaces"), but stored
 unescaped inside KCompletion.
 Never delete that pointer!

 Default implementation does nothing.

*/
- postProcessMatch: (NSString *)arg1;

/** 
 This method is called before a list of all available completions is
 emitted via @ref matches. You can override this method to modify the
 found items before @ref -match or @ref -matches are emitted.
 Never delete that pointer!

 Default implementation does nothing.

*/
- postProcessMatches: (NSArray *)arg1;

/** 
 This method is called before a list of all available completions is
 emitted via @ref matches. You can override this method to modify the
 found items before @ref -match or @ref -matches are emitted.
 Never delete that pointer!

 Default implementation does nothing.

*/
- postProcessCompletionMatches: (KCompletionMatches*)arg1;
+ (int) Sorted;
+ (int) Insertion;
+ (int) Weighted;
@end

/** Override these methods in subclasses of KCompletion to customise event handling behaviour */
@protocol KCompletionEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
