/***************************************************************************
                            HTMLImageElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLIMAGEELEMENT_H
#define HTMLIMAGEELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Embedded image. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html edef]-IMG">
 IMG element definition </a> in HTML 4.0.

 
 @short 
 Embedded image.
*/

@interface HTMLImageElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 The name of the element (for backwards compatibility).

     
*/
- (NSString *) name;

/** 
 see @ref name
     
*/
- setName: (NSString *)arg1;

/** 
 Aligns this object (vertically or horizontally) with respect to
 its surrounding text. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-align-IMG">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) align;

/** 
 see @ref align
     
*/
- setAlign: (NSString *)arg1;

/** 
 Alternate text for user agents not rendering the normal content
 of this element. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-alt">
 alt attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) alt;

/** 
 see @ref alt
     
*/
- setAlt: (NSString *)arg1;

/** 
 Width of border around image. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-border-IMG">
 border attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (long) border;

/** 
 see @ref border
     
*/
- setBorder: (long)arg1;

/** 
 Override height. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-height-IMG">
 height attribute definition </a> in HTML 4.0.

     
*/
- (long) height;

/** 
 see @ref height
     
*/
- setHeight: (long)arg1;

/** 
 Horizontal space to the left and right of this image. See the
 <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-hspace">
 hspace attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (long) hspace;

/** 
 see @ref hspace
     
*/
- setHspace: (long)arg1;

/** 
 Use server-side image map. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-ismap">
 ismap attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) isMap;

/** 
 see @ref isMap
     
*/
- setIsMap: (BOOL)arg1;

/** 
 URI designating a long description of this image or frame. See
 the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-longdesc-IMG">
 longdesc attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) longDesc;

/** 
 see @ref longDesc
     
*/
- setLongDesc: (NSString *)arg1;

/** 
 URI designating the source of this image. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-src-IMG">
 src attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) src;

/** 
 see @ref src
     
*/
- setSrc: (NSString *)arg1;

/** 
 Use client-side image map. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-usemap">
 usemap attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) useMap;

/** 
 see @ref useMap
     
*/
- setUseMap: (NSString *)arg1;

/** 
 Vertical space above and below this image. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-vspace">
 vspace attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (long) vspace;

/** 
 see @ref vspace
     
*/
- setVspace: (long)arg1;

/** 
 Override width. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-width-IMG">
 width attribute definition </a> in HTML 4.0.

     
*/
- (long) width;

/** 
 see @ref width
     
*/
- setWidth: (long)arg1;
@end

#endif
