/***************************************************************************
                            HTMLDocument.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLDOCUMENT_H
#define HTMLDOCUMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/DOMDocument.h>

/**

 An <code> HTMLDocument </code> is the root of the HTML hierarchy
 and holds the entire content. Beside providing access to the
 hierarchy, it also provides some convenience methods for accessing
 certain sets of information from the document.

  The following properties have been deprecated in favor of the
 corresponding ones for the BODY element:

  <ulist> <item> alinkColor

  </item> <item> background

  </item> <item> bgColor

  </item> <item> fgColor

  </item> <item> linkColor

  </item> <item> vlinkColor

  </item> </ulist>

 
 @short 
 An <code> HTMLDocument </code> is the root of the HTML hierarchy
 and holds the entire content.
*/

@class KHTMLView;
@class DOMNode;
@class HTMLElement;
@class HTMLCollection;
@class Element;

@interface HTMLDocument : DOMDocument
- init;

/** 
 The parent is the widget the document should render itself in.
 Rendering information (like sizes, etc...) is only created if
 parent != 0
     
*/
- initWithHTMLView: (KHTMLView*)parent;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 The title of a document as specified by the <code> TITLE
 </code> element in the head of the document.

     
*/
- (NSString *) title;

/** 
 see @ref title
     
*/
- setTitle: (NSString *)arg1;

/** 
 Returns the URI of the page that linked to this page. The value
 is an empty string if the user navigated to the page directly
 (not through a link, but, for example, via a bookmark).
     
*/
- (NSString *) referrer;

/** 
 The domain name of the server that served the document, or a
 null string if the server cannot be identified by a domain
 name.

     
*/
- (NSString *) domain;

/** 
 The absolute URI of the document.
     
*/
- (NSString *) URL;

/** 
 The element that contains the content for the document. In
 documents with <code> BODY </code> contents, returns the <code>
 BODY </code> element, and in frameset documents, this returns
 the outermost <code> FRAMESET </code> element.

     
*/
- (HTMLElement*) body;

/** 
 see @ref body
     
*/
- setBody: (HTMLElement*)arg1;

/** 
 A collection of all the <code> IMG </code> elements in a
 document. The behavior is limited to <code> IMG </code>
 elements for backwards compatibility.

     
*/
- (HTMLCollection*) images;

/** 
 A collection of all the <code> OBJECT </code> elements that
 include applets and <code> APPLET </code> ( deprecated )
 elements in a document.

     
*/
- (HTMLCollection*) applets;

/** 
 A collection of all <code> AREA </code> elements and anchor (
 <code> A </code> ) elements in a document with a value for the
 <code> href </code> attribute.

     
*/
- (HTMLCollection*) links;

/** 
 A collection of all the forms of a document.

     
*/
- (HTMLCollection*) forms;

/** 
 A collection of all the anchor ( <code> A </code> ) elements in
 a document with a value for the <code> name </code> attribute.
 Note. For reasons of backwards compatibility, the returned set
 of anchors only contains those anchors created with the <code>
 name </code> attribute, not those created with the <code> id
 </code> attribute.

     
*/
- (HTMLCollection*) anchors;

/** 
 The cookies associated with this document. If there are none,
 the value is an empty string. Otherwise, the value is a string:
 a semicolon-delimited list of "name, value" pairs for all the
 cookies associated with the page. For example, <code>
 name=value;expires=date </code> .

     
*/
- (NSString *) cookie;

/** 
 see @ref cookie
     
*/
- setCookie: (NSString *)arg1;

/** 
 Note. This method and the ones following allow a user to add to
 or replace the structure model of a document using strings of
 unparsed HTML. At the time of writing alternate methods for
 providing similar functionality for both HTML and XML documents
 were being considered. The following methods may be deprecated
 at some point in the future in favor of a more general-purpose
 mechanism.

  Open a document stream for writing. If a document exists in
 the target, this method clears it.

     
*/
- open;

/** 
 Closes a document stream opened by <code> -open </code> and
 forces rendering.

     
*/
- close;

/** 
 Write a string of text to a document stream opened by <code>
 -open </code> . The text is parsed into the document's
 structure model.

     
*/
- write: (NSString *)text;

/** 
 Write a string of text followed by a newline character to a
 document stream opened by <code> -open </code> . The text is
 parsed into the document's structure model.

     
*/
- writeln: (NSString *)text;

/** 
 Returns the (possibly empty) collection of elements whose
 <code> name </code> value is given by <code> elementName
 </code> .

     
*/
//- (NSArray *) getElementsByName: (NSString *)elementName;

/** 
 not part of the DOM

 converts the given (potentially relative) URL in a
 full-qualified one, using the baseURL / document URL for
 the missing parts.
     
*/
- (NSString *) completeURL: (NSString *)url;

/** 
 Not part of the DOM

 The date the document was last modified.
     
*/
- (NSString *) lastModified;

/** 
 Not part of the DOM

 A collection of all the <code>IMG</code>, <code>OBJECT</code>,
 <code>AREA</code>, <code>A</code>, forms and anchor elements of
 a document.
     
*/
- (HTMLCollection*) all;
@end

#endif
