/***************************************************************************
                            KPopupMenu.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KPopupMenu is a class for menus with standard title items and keyboard
 accessibility for popups with many options and/or varying options. It acts
 identically to QPopupMenu, with the addition of insertTitle(),
 changeTitle(), setKeyboardShortcutsEnabled() and
 setKeyboardShortcutsExecute() methods.

 The titles support a text string, an icon, plus user defined gradients,
 colors, and background pixmaps.

 The keyboard search algorithm is incremental with additional underlining
 for user feedback.

 See {@link KPopupMenuSignals} for signals emitted by KPopupMenu.

 

 @author Hamish Rodda <meddie@yoyo.its.monash.edu.au>
 
 @short A menu with title items.

*/
public class KPopupMenu extends QPopupMenu  {
	protected KPopupMenu(Class dummy){super((Class) null);}

	private native void newKPopupMenu( QWidget parent, String name);

/** 
 Constructs a KPopupMenu.
     
*/
	public KPopupMenu( QWidget parent, String name) {
		super((Class) null);
		newKPopupMenu( parent, name);
	}
	private native void newKPopupMenu();
	public KPopupMenu() {
		super((Class) null);
		newKPopupMenu();
	}

/** 
 Destructs the object
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Inserts a title item with no icon.
     
*/
	public native int insertTitle( String text, int identifier, int index);
	public native int insertTitle( String text);

/** 
 Inserts a title item with the given icon and title.
     
*/
	public native int insertTitle( QPixmap icon, String text, int identifier, int index);
	public native int insertTitle( QPixmap icon, String text);

/** 
 Changes the title of the item at the specified id. If a icon was
 previously set it is cleared.
     
*/
	public native void changeTitle( int identifier, String text);

/** 
 Changes the title and icon of the title item at the specified id.
     
*/
	public native void changeTitle( int identifier, QPixmap icon, String text);

/** 
 Returns the title of the title item at the specified id. The default
 id of -1 is for backwards compatibility only, you should always specify
 the id.
     
*/
	public native String title( int identifier);
	public native String title();

/** 
 Returns the icon of the title item at the specified id.
     
*/
	public native QPixmap titlePixmap( int identifier);

/** 
 Enables keyboard navigation by searching for the entered key sequence.
 Also underlines the currently selected item, providing feedback on the search.

 Defaults to off.

 WARNING: calls to text() of currently keyboard-selected items will
 contain additional ampersand characters.

 WARNING: though pre-existing keyboard shortcuts will not interfere with the
 operation of this feature, they may be confusing to the user as the existing
 shortcuts will not work.

*/
	public native void setKeyboardShortcutsEnabled( boolean enable);

/** 
 Enables execution of the menu item once it is uniquely specified.
 Defaults to off.

*/
	public native void setKeyboardShortcutsExecute( boolean enable);
	private native void newKPopupMenu( String title, QWidget parent, String name);

/** 
 Obsolete method provided for backwards compatibility only. Use the
 normal constructor and insertTitle instead.
     
*/
	public KPopupMenu( String title, QWidget parent, String name) {
		super((Class) null);
		newKPopupMenu( title, parent, name);
	}
	private native void newKPopupMenu( String title);
	public KPopupMenu( String title) {
		super((Class) null);
		newKPopupMenu( title);
	}

/** 
 Obsolete method provided for backwards compatibility only. Use
 insertTitle and changeTitle instead.
     
*/
	public native void setTitle( String title);
	protected native void closeEvent( QCloseEvent arg1);
	protected native void keyPressEvent( QKeyEvent e);
	protected native void virtual_hook( int identifier, int data);
	protected native String underlineText( String text, int length);
	protected native void resetKeyboardVars( boolean noMatches);
	protected native void resetKeyboardVars();
}
