/***************************************************************************
                            KPasswordDialog.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This dialog asks the user to enter a password. The functions you're 
 probably interested in are the static methods, {@link #getPassword} and
 {@link #getNewPassword}.

 <pre>
 QCString password;
 int result = KPasswordDialog.getPassword(password, i18n("Password"));
 if (result == KPasswordDialog.Accepted)
     use(password);
 </pre>

 Keeping passwords in memory can be a potential security hole. You should
 handle this situation with care.

 See {@link KPasswordDialogSignals} for signals emitted by KPasswordDialog.

 

 @author Geert Jansen <jansen@kde.org>
 
 @short A password input dialog.

*/
public class KPasswordDialog extends KDialogBase  {
	protected KPasswordDialog(Class dummy){super((Class) null);}

	private native void newKPasswordDialog( int type, boolean enableKeep, int extraBttn, QWidget parent, String name);

/** 
 Constructs a password dialog.

*/
	public KPasswordDialog( int type, boolean enableKeep, int extraBttn, QWidget parent, String name) {
		super((Class) null);
		newKPasswordDialog( type, enableKeep, extraBttn, parent, name);
	}
	private native void newKPasswordDialog( int type, boolean enableKeep, int extraBttn);
	public KPasswordDialog( int type, boolean enableKeep, int extraBttn) {
		super((Class) null);
		newKPasswordDialog( type, enableKeep, extraBttn);
	}
	private native void newKPasswordDialog( int type, String prompt, boolean enableKeep, int extraBttn);

/** 

 possibility to specify a parent. May be removed in KDE 4.0
     
*/
	public KPasswordDialog( int type, String prompt, boolean enableKeep, int extraBttn) {
		super((Class) null);
		newKPasswordDialog( type, prompt, enableKeep, extraBttn);
	}
	private native void newKPasswordDialog( int type, String prompt);
	public KPasswordDialog( int type, String prompt) {
		super((Class) null);
		newKPasswordDialog( type, prompt);
	}

/** 
 Destructs the password dialog.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the password prompt.
     
*/
	public native void setPrompt( String prompt);

/** 
 Returns the password prompt.
     
*/
	public native String prompt();

/** 
 Adds a line of information to the dialog.
     
*/
	public native void addLine( String key, String value);

/**  
 Returns the password entered. The memory is freed in the destructor,
 so you should make a copy.
     
*/
	public native String password();

/** 
 Returns true if the user wants to keep the password.
     
*/
	public native boolean keep();

/** 
 Pops up the dialog, asks the user for a password, and returns it.

*/
	public static native int getPassword( String password, String prompt, int[] keep);
	public static native int getPassword( String password, String prompt);

/**  
 Pops up the dialog, asks the user for a password and returns it. The
 user has to enter the password twice to make sure it was entered
 correctly.

*/
	public static native int getNewPassword( String password, String prompt);

/** 
 Static helper funtion that disables core dumps.
     
*/
	public static native void disableCoreDumps();

/** 
 Virtual function that can be overridden to provide password
 checking in derived classes. It should return <code>true</code> if the
 password is valid, <code>false</code> otherwise.
     
*/
	protected native boolean checkPassword( String arg1);
	protected native void virtual_hook( int identifier, int data);
	protected native void slotOk();
	protected native void slotCancel();
	protected native void slotKeep( boolean arg1);
	public static final int /***Theuserisaskedtoenterapassword.*/Password = 0;
	public static final int /***Theuserisaskedtoenterapasswordandtoconfirmit*asecondtime.Thisisusuallyusedwhentheuser*changeshispassword.*/NewPassword = 1;
}
