/***************************************************************************
                            KLineEditDlg.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Dialog for user to enter a single line of text.

 See {@link KLineEditDlgSignals} for signals emitted by KLineEditDlg.

 

 @author David Faure <faure@kde.org>, layout management by Preston Brown <pbrown@kde.org>
 
 @version $Id: KLineEditDlg.java,v 1.7 2002/11/26 04:17:33 rdale Exp $

 @short *
 Dialog for user to enter a single line of text.
*/
public class KLineEditDlg extends KDialogBase  {
	protected KLineEditDlg(Class dummy){super((Class) null);}

	private native void newKLineEditDlg( String _text, String _value, QWidget parent);

/** 
 Create a dialog that asks for a single line of text. _value is
 the initial value of the line. _text appears as label on top of
 the entry box. If the internal line edit has an associated {@link QValidator} set, the OK button is disabled as long as the
 validator doesn't return Acceptable. If there's no validator, the
 OK button is enabled whenever the line edit isn't empty.

 If you want to accept empty input, make a trivial QValidator that
 always returns Acceptable, e.g. {@link QRegExpValidator} with a
 regexp of ".".

*/
	public KLineEditDlg( String _text, String _value, QWidget parent) {
		super((Class) null);
		newKLineEditDlg( _text, _value, parent);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

*/
	public native String text();

/** 

*/
	public native KLineEdit lineEdit();

/** 
 Clears the edit widget
   
*/
	public native void slotClear();

/** 
 Static convenience function to get a textual input from the user.

*/
	public static native String getText( String _text, String _value, boolean[] ok, QWidget parent, QValidator validator);
	public static native String getText( String _text, String _value, boolean[] ok, QWidget parent);

/** 
 Static convenience function to get a textual input from the user.
 This method includes a caption, and has (almost) the same API as QInputDialog.getText
 (no echo mode, we have KPasswordDialog).

*/
	public static native String getText( String _caption, String _text, String _value, boolean[] ok, QWidget parent, QValidator validator);
	public static native String getText( String _caption, String _text);

/** 
 The line edit widget
   
*/
	protected native void virtual_hook( int identifier, int data);

/**  
 Enables and disables the OK button depending on the state
 returned by the lineedit's {@link QValidator}.
   
*/
	protected native void slotTextChanged( String arg1);
}
