package org.kde.koala;
import org.kde.qt.*;


/** {@link KHTMLPart} emits these signals */
public interface KHTMLPartSignals {
	void customEvent( QCustomEvent event );

/** 
 Eventhandler for the khtml.MouseDoubleClickEvent.
   
*/
	void khtmlMouseDoubleClickEvent( MouseDoubleClickEvent arg1 );
	void setPluginPageQuestionAsked( String mimetype );

/** 
 This signal is emitted when an element retrieves the
 keyboard focus. Note that the signal argument can be
 a null node if no element is active, meaning a node
 has explicitly been deactivated without a new one
 becoming active.
   
*/
	void nodeActivated( DOMNode arg1 );

/** 
 Emitted if the cursor is moved over an URL.
   
*/
	void onURL( String url );

/** 
 Emitted by the part, to set the caption of the window(s)
 hosting this part
     
*/
	void setWindowCaption( String caption );

/** 
 Eventhandler for the khtml.MouseDoubleMoveEvent.
   
*/
	void khtmlMouseMoveEvent( MouseMoveEvent event );

/** 
 Internal empty reimplementation of {@link KParts#ReadOnlyPart}.openFile .
   
*/
	void openFile();

/** 
 Eventhandler for the khtml.DrawContentsEvent.
   
*/
	void khtmlDrawContentsEvent( DrawContentsEvent arg1 );

/** 
 presents a detailed error message to the user.
 <code>errorCode</code> kio error code, eg KIO.ERR_SERVER_TIMEOUT.
 <code>text</code> kio additional information text.
 <code>url</code> the url that triggered the error.
   
*/
	void htmlError( int errorCode, String text, KURL reqUrl );
	void urlSelected( String url, int button, int state, String _target, int arg1 );

/** 
 Eventhandler for the khtml.MouseMoveEvent.
   
*/
	void khtmlMouseReleaseEvent( MouseReleaseEvent event );
	void destroyed( QObject obj );
	void pluginPageQuestionAsked( String mimetype );

/** 
 Emit this if loading is canceled by the user or by an error.

*/
	void canceled( String errMsg );

/** 

  void docCreated();

protected:

  /
 returns a KURL object for the given url. Use when
 you know what you're doing.
   
*/
	void completeURL( String url );

/** 
 The part emits this when starting data.
 If using a KIO.Job, it sets the job in the signal, so that
 progress information can be shown. Otherwise, job is 0.

*/
	void started( Job arg1 );

/** 
 This method is called when a new embedded object (include html frames) is to be created.
 Reimplement it if you want to add support for certain embeddable objects without registering
 them in the KDE wide registry system (KSyCoCa) . Another reason for re-implementing this
 method could be if you want to derive from KTHMLPart and also want all html frame objects
 to be a object of your derived type, in which case you should return a new instance for
 the mimetype 'text/html' .
   
*/
	void createPart( QWidget parentWidget, String widgetName, QObject parent, String name, String mimetype, String serviceName, String[] serviceTypes, String[] params );

/** 
 This signal is emitted when the selection changes.
   
*/
	void selectionChanged();

/** 
 Internal reimplementation of KParts.Part.guiActivateEvent .
   
*/
	void guiActivateEvent( GUIActivateEvent event );

/** 
 Eventhandler of the khtml.MousePressEvent.
   
*/
	void khtmlMousePressEvent( MousePressEvent event );

/** 
 Same as the above signal except besides indicating that the data has
 been completely loaded it also informs the host, by setting the flag,
 that a pending action has been generated as a result of completing the
 requested task (loading the data).  An example of this is meta-refresh
 tags on HTML pages which result in the page either being refreshed or
 the viewer being redirected to another page.  By emitting this signal
 after appropriately setting the flag, the part can tell the host of the
 pending scheduled action inorder to give it a chance to accept or cancel
 that action.

 <code>pendingAction</code>  if true, a pending action exists (ex: a scheduled refresh)
   
*/
	void completed( boolean pendingAction );
}

