/***************************************************************************
                            KFilePreview.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 See {@link KFilePreviewSignals} for signals emitted by KFilePreview.

 

*/
public class KFilePreview extends QSplitter implements  KFileViewInterface {
	protected KFilePreview(Class dummy){super((Class) null);}

	private native void newKFilePreview( QWidget parent, String name);
	public KFilePreview( QWidget parent, String name) {
		super((Class) null);
		newKFilePreview( parent, name);
	}
	private native void newKFilePreview( KFileViewInterface view, QWidget parent, String name);
	public KFilePreview( KFileViewInterface view, QWidget parent, String name) {
		super((Class) null);
		newKFilePreview( view, parent, name);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native QWidget widget();
	public native void clearView();

/** 
 Delets the current view and sets the view to the given <code>view.</code>
 The view is reparented to have this as parent, if necessary.
     
*/
	public native void setFileView( KFileViewInterface view);

/** 

*/
	public native KFileViewInterface fileView();
	public native void updateView( boolean arg1);
	public native void updateView( KFileItem arg1);
	public native void removeItem( KFileItem arg1);
	public native void listingCompleted();
	public native void setSelectionMode( int sm);
	public native void setSelected( KFileItem arg1, boolean arg2);
	public native boolean isSelected( KFileItem arg1);
	public native void clearSelection();
	public native void selectAll();
	public native void invertSelection();
	public native void insertItem( KFileItem arg1);
	public native void clear();
	public native void setCurrentItem( KFileItem arg1);
	public native KFileItem currentFileItem();
	public native KFileItem firstFileItem();
	public native KFileItem nextItem( KFileItem arg1);
	public native KFileItem prevItem( KFileItem arg1);
	public native void setSorting( int sort);

/** 
 This overrides KFileView.actionCollection() by returning
 the actionCollection() of the KFileView (member left) it contains.
 This means that KFilePreview will never create a KActionCollection
 object of its own.
     
*/
	public native KActionCollection actionCollection();
	public native void ensureItemVisible( KFileItem arg1);
	public native void setPreviewWidget( QWidget w, KURL u);
	protected native void virtual_hook( int identifier, int data);
	protected native void slotHighlighted( KFileItem arg1);
	
	// From KFileViewInterface
	

/**
 Sets <code>filename</code> the current item in the view, if available.

*/
	public native void setCurrentItem( String filename);


	public native void updateView();

/**
 Returns the sorting order of the internal list. Newly added files
 are added through this sorting.

*/
	public native boolean sorting();


/**
 Tells whether the current items are in reversed order (shortcut to
 sorting() & QDir.Reversed).

*/
	public native boolean isReversed();
	public native void sortReversed();

/**

*/
	public native int count();

/**

*/
	public native int numFiles();

/**

*/
	public native int numDirs();
	public native int selectionMode();
	public native void setViewMode( int vm);
	public native int viewMode();

/**

*/
	public native String viewName();

/**
 Sets the name of the view, which could be displayed somewhere.
 E.g. "Image Preview".

*/
	public native void setViewName( String name);
	public native void setParentView( KFileViewInterface parent);

/**

*/
	public native ArrayList selectedItems();

/**

*/
	public native ArrayList items();

/**
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 Every view has to decide when to call select( item ) when a file was
 single-clicked, based on {@link #onlyDoubleClickSelectsFiles}.

*/
	public native void setOnlyDoubleClickSelectsFiles( boolean enable);

/**

*/
	public native boolean onlyDoubleClickSelectsFiles();

/**
 increases the number of dirs and files.

*/
	public native boolean updateNumbers( KFileItem i);

/**

*/
//	public native KActionCollection actionCollection();
	public native KFileViewSignaler signaler();
	public native void readConfig( KConfig arg1, String group);
	public native void readConfig( KConfig arg1);
	public native void writeConfig( KConfig arg1, String group);
	public native void writeConfig( KConfig arg1);
	public static native String sortingKey( String value, boolean isDir, int sortSpec);
	public static native String sortingKey( int value, boolean isDir, int sortSpec);

}
