package org.kde.koala;
import org.kde.qt.*;


/** {@link KDockWidget} emits these signals */
public interface KDockWidgetSignals {

/** 
 Emitted when the widget has undocked.
   
*/
	void hasUndocked();

/** 
 Emitted when the dockback button of the panel ({@link KDockWidgetHeader}) has been clicked.
   
*/
	void headerDockbackButtonClicked();
	void destroyed( QObject obj );

/** 
 Emitted when the widget processes a close event.
   
*/
	void iMBeingClosed();

/** 
 Signals that the dock default position is set.
   
*/
	void setDockDefaultPos();

/** 
 Emitted when the close button of the panel ({@link KDockWidgetHeader}) has been clicked.
   
*/
	void headerCloseButtonClicked();

/** 
 Emitted when another dock widget is docking to this.

*/
	void docking( KDockWidget dw, int dp );
}

