/***************************************************************************
                            KConfigGroupSaver.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Helper class to facilitate working with {@link KConfig} / {@link KSimpleConfig}
 groups.

 Careful programmers always set the group of a
 {@link KConfig} {@link KSimpleConfig} object to the group they want to read from
 and set it back to the old one of afterwards. This is usually
 written as:
 <pre>

 String oldgroup config.group();
 config.setGroup( "TheGroupThatIWant" );
 ...
 config.writeEntry( "Blah", "Blubb" );

 config.setGroup( oldgroup );
 </pre>

 In order to facilitate this task, you can use
 KConfigGroupSaver. Simply construct such an object ON THE STACK
 when you want to switch to a new group. Then, when the object goes
 out of scope, the group will automatically be restored. If you
 want to use several different groups within a function or method,
 you can still use KConfigGroupSaver: Simply enclose all work with
 one group (including the creation of the KConfigGroupSaver object)
 in one block.

 @author Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: KConfigGroupSaver.java,v 1.7 2002/11/26 04:17:32 rdale Exp $

 @short Helper class for easier use of KConfig/KSimpleConfig groups.
*/
public class  KConfigGroupSaver implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KConfigGroupSaver(Class dummy){}

	private native void newKConfigGroupSaver( KConfigBase config, String group);

/** 
 Constructor. You pass a pointer to the KConfigBase-derived
 object you want to work with and a string indicating the _new_
 group.

*/
	public KConfigGroupSaver( KConfigBase config, String group) {
		newKConfigGroupSaver( config, group);
	}
//	private native void newKConfigGroupSaver( KConfigBase config, String group);
//	public KConfigGroupSaver( KConfigBase config, String group) {
//		newKConfigGroupSaver( config, group);
//	}
//	private native void newKConfigGroupSaver( KConfigBase config, String group);
//	public KConfigGroupSaver( KConfigBase config, String group) {
//		newKConfigGroupSaver( config, group);
//	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native KConfigBase config();
}
