/***************************************************************************
                            DCOPObjectInterface.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import java.util.ArrayList;
import org.kde.qt.*;

public interface DCOPObjectInterface {

/** 
 Returns the object id of the DCOPObject.

*/
	String objId();

/** 
 Renames a dcop object, if no other with the same name exists
 Use with care, all dcop signals are disconnected

*/
	boolean setObjId( String objId);

/** 
 Dispatches a message.

 Usually you want to use an IDL
 compiler to automatically generate an implementation for
 this function.

 If this function returns false, then {@link #processDynamic}
 is called.

 Note to implementators: remember to call the baseclasses
 implementation. It handles the functions "functions()" and
 "interfaces()" which return the lists of supported functions
 and interfaces, respectively.

*/
	boolean process( String fun, byte[] data, String replyType, byte[] replyData);

/** 
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #process} but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
	boolean processDynamic( String fun, byte[] data, String replyType, byte[] replyData);

/** 
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #functions} but
 you still want to list some functions dynamically.
 Dynamically means that the methods may appear and vanish
 during runtime.

*/
	ArrayList functionsDynamic();

/** 
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #interfaces} but
 you still want to list some interfaces dynamically.
 Dynamically means that they may appear and vanish
 during runtime.

*/
	ArrayList interfacesDynamic();

/** 
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
	ArrayList interfaces();

/** 
 Returns the list of functions understood by the object. It gets
 reimplemented by the IDL compiler. If you don't use the IDL
 compiler, consider implementing this function manually if you
 want your object to be easily scriptable.

 Rationale: functions() allows an interpreter to do client-side
 type-casting properly.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	ArrayList functions();

/** 
 Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as
 arguments

*/
	void emitDCOPSignal( String signal, byte[] data);

/** 
 Connects to a DCOP signal.

*/
	boolean connectDCOPSignal( String sender, String senderObj, String signal, String slot, boolean Volatile);

/** 
 Disconnects a DCOP signal.

 A special case is when both <code>sender</code> & <code>signal</code> are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
	boolean disconnectDCOPSignal( String sender, String senderObj, String signal, String slot);

/** 
 Returns the {@link DCOPClient} responsible for making the call. 
 Only call this function while you are handling a DCOP call.

*/
	DCOPClient callingDcopClient();

/** 

*/
	void setCallingDcopClient( DCOPClient arg1);
}
