/***************************************************************************
                            kde_MainWindow.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_MAINWINDOW
#define KDE_MAINWINDOW

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A KPart-aware main window, whose user interface is described in XML.

 Inherit your main window from this class
 and don't forget to call @ref setXMLFile() in the inherited constructor.

 It implements all internal interfaces in the case of a
 @ref KMainWindow as host: the builder and servant interface (for menu
 merging).
 
 @short *
 A KPart-aware main window, whose user interface is described in XML.
*/

/** *
 Constructor, same signature as @ref KMainWindow.
   
*/
kde_MainWindow * kde_new_MainWindow(qt_QWidget * parent, char* name, int f);

/** *
 Compatibility Constructor, same signature as @ref KMainWindow.
   
*/
kde_MainWindow * kde_new_MainWindow1(char* name, int f);

/** *
 Destructor.
   
*/
void kde_del_MainWindow( kde_MainWindow* p );
void kde_MainWindow_createShellGUI(kde_MainWindow* instPointer,int create);

/** *
 Create the GUI (by merging the host's and the active part's)
 You _must_ call this in order to see any GUI being created.

 In a main window with multiple parts being shown (e.g. as in Konqueror)
 you need to connect this slot to the
 @ref KPartManager::activePartChanged() signal

*/
void kde_MainWindow_createGUI(kde_MainWindow* instPointer,kde_Part* part);

/** *
 Called when the active part wants to change the statusbar message
 Reimplement if your mainwindow has a complex statusbar
 (with several items)
   
*/
void kde_MainWindow_slotSetStatusBarText(kde_MainWindow* instPointer,qt_QString * arg1);

/** Casts a 'kde_MainWindow *' to a 'kde_KMainWindow*' */
kde_KMainWindow* kde_MainWindow_KMainWindow(kde_MainWindow* instPointer);

/** Casts a 'kde_MainWindow *' to a 'kde_PartBase*' */
kde_PartBase* kde_MainWindow_PartBase(kde_MainWindow* instPointer);

#endif
