/***************************************************************************
                            kde_KService.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSERVICE
#define KDE_KSERVICE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Represent a service, i.e. an application bound to one or several mimetypes
 (or servicetypes) as written in its desktop entry file.

 A service may be a library, too.
 The starting point you need is often the static methods.

 @author Torben Weis <weis@kde.org>
 
 @short *
 Represent a service, i.
*/
#define KSERVICE_DCOP_None	0
#define KSERVICE_DCOP_Unique	0
#define KSERVICE_DCOP_Multi	1
#define KSERVICE_DCOP_Wait	2

/** *
 Construct a temporary service with a given name, exec-line and icon.
   
*/
kde_KService * kde_new_KService(qt_QString * _name, qt_QString * _exec, qt_QString * _icon);

/** *
 Construct a service and take all information from a config file.

*/
kde_KService * kde_new_KService1(qt_QString * _fullpath);

/** *
 Construct a service and take all information from a desktop file.
   
*/
kde_KService * kde_new_KService2(kde_KDesktopFile* config);

/** *

 Construct a service from a stream.
 The stream must already be positionned at the correct offset.
   
*/
kde_KService * kde_new_KService3(qt_QDataStream * _str, int offset);
void kde_del_KService( kde_KService* p );

/** *

*/
qt_QString * kde_KService_type(kde_KService* instPointer);

/** *

*/
qt_QString * kde_KService_name(kde_KService* instPointer);

/** *

*/
qt_QString * kde_KService_exec(kde_KService* instPointer);

/** *

*/
qt_QString * kde_KService_library(kde_KService* instPointer);

/** *

*/
qt_QString * kde_KService_init(kde_KService* instPointer);

/** *

*/
qt_QString * kde_KService_icon(kde_KService* instPointer);

/** *

*/
qt_QPixmap * kde_KService_pixmap(kde_KService* instPointer,int _group, int _force_size, int _state, qt_QString* _path);

/** *

*/
int kde_KService_terminal(kde_KService* instPointer);

/** *

 The service must be a tty-oriented program.
   
*/
qt_QString * kde_KService_terminalOptions(kde_KService* instPointer);

/** *

*/
int kde_KService_substituteUid(kde_KService* instPointer);

/** *

*/
qt_QString * kde_KService_username(kde_KService* instPointer);

/** *

 This is a relative path if the desktop entry was found in any
 of the locations pointed to by $KDEDIRS (e.g. "Internet/kppp.desktop")
 It is a full path if the desktop entry originates from another
 location.
   
*/
qt_QString * kde_KService_desktopEntryPath(kde_KService* instPointer);

/** *

*/
qt_QString * kde_KService_desktopEntryName(kde_KService* instPointer);

/** *

*/
int kde_KService_DCOPServiceType(kde_KService* instPointer);

/** *

*/
qt_QString * kde_KService_path(kde_KService* instPointer);

/** *

*/
qt_QString * kde_KService_comment(kde_KService* instPointer);

/** *

*/
qt_QString * kde_KService_genericName(kde_KService* instPointer);

/** *

*/
qt_QStringList* kde_KService_keywords(kde_KService* instPointer);

/** *

*/
qt_QStringList* kde_KService_categories(kde_KService* instPointer);

/** *

*/
qt_QStringList* kde_KService_serviceTypes(kde_KService* instPointer);

/** *

*/
int kde_KService_hasServiceType(kde_KService* instPointer,qt_QString * _service);

/** *

*/
int kde_KService_allowAsDefault(kde_KService* instPointer);

/** *

*/
int kde_KService_allowMultipleFiles(kde_KService* instPointer);

/** *
 What preference to associate with this service initially (before
 the user has had any chance to define a profile for it)
 The bigger the value, the most preferred the service is.
   
*/
int kde_KService_initialPreference(kde_KService* instPointer);

/** *

   
*/
void kde_KService_setInitialPreference(kde_KService* instPointer,int i);

/** *
 Whether the entry should be suppressed in menus.
   
*/
int kde_KService_noDisplay(kde_KService* instPointer);

/** *
 Name of the application this service belongs to.
 (Usefull for e.g. plugins)

*/
qt_QString * kde_KService_parentApp(kde_KService* instPointer);

/** *

         It depends upon the @ref serviceTypes() of this service which
         properties a service can have.

*/
qt_QVariant * kde_KService_property(kde_KService* instPointer,qt_QString * _name);

/** *

*/
qt_QStringList* kde_KService_propertyNames(kde_KService* instPointer);

/** *

*/
int kde_KService_isValid(kde_KService* instPointer);

/** *

 Load the service from a stream.
   
*/
void kde_KService_load(kde_KService* instPointer,qt_QDataStream * arg1);

/** *

 Save the service to a stream.
   
*/
void kde_KService_save(kde_KService* instPointer,qt_QDataStream * arg1);

/** *
 Find a service by name, i.e. the translated Name field. You should
 really not use this method, since the name is translated.

*/
void * kde_KService_serviceByName( qt_QString * _name);

/** *
 Find a service by its relative path to the applnk or services
 directory, for instance "Internet/konqbrowser.desktop". Better not use
 it for menu entries though, since the user can move them.
 It's ok to use it for services though (e.g. "http_cache_cleaner.desktop")

*/
void * kde_KService_serviceByDesktopPath( qt_QString * _name);

/** *
 Find a service by the name of its desktop file, not depending on
 its actual location (as long as it's under the applnk or service
 directories). For instance "konqbrowser" or "kcookiejar". Note that
 the ".desktop" extension is implicit.

 This is the recommended method (safe even if the user moves stuff)
 but note that it assumes that no two entries have the same filename.

*/
void * kde_KService_serviceByDesktopName( qt_QString * _name);

/** *

  Useful for being able to
 to display them in a list box, for example.
 More memory consuming than the ones above, don't use unless
 really necessary.
   
*/
//kde_List kde_KService_allServices( );

/** *

 Only needed by "kcminit"
   
*/
//kde_List kde_KService_allInitServices( );
void kde_KService_init1(kde_KService* instPointer,kde_KDesktopFile* config);
qt_QStringList* kde_KService_accessServiceTypes(kde_KService* instPointer);
void kde_KService_virtual_hook(kde_KService* instPointer,int identifier, void* data);

#endif
