/***************************************************************************
                            kde_KScriptClientInterface.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSCRIPTCLIENTINTERFACE
#define KDE_KSCRIPTCLIENTINTERFACE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
	This class is used for allowing feedback to the main system.

 @author Ian Reinhart Geiser <geiseri@kde.org>

 @short *
	This class is used for allowing feedback to the main system.
*/
#define KSCRIPTCLIENTINTERFACE_ResultSuccess	0
#define KSCRIPTCLIENTINTERFACE_ResultFailure	1
#define KSCRIPTCLIENTINTERFACE_ResultContinue	2
#define KSCRIPTCLIENTINTERFACE_ResultBreak	3

/** *
	This function will allow the main application of any errors
	that have occured during processing of the script.
		
*/
void kde_KScriptClientInterface_error(kde_KScriptClientInterface* instPointer,qt_QString * msg);

/** *
	This function will allow the main application of any warnings
	that have occured during the processing of the script.
		
*/
void kde_KScriptClientInterface_warning(kde_KScriptClientInterface* instPointer,qt_QString * msg);

/** *
	This function will allow the main application of any normal
	output that has occured during the processing of the script.
		
*/
void kde_KScriptClientInterface_output(kde_KScriptClientInterface* instPointer,qt_QString * msg);

/** *
	This function will allow feedback to any progress bars in the main
	application as to how far along the script is.  This is very useful when
	a script is processing files or doing some long operation that is of a
	known duration.
		
*/
void kde_KScriptClientInterface_progress(kde_KScriptClientInterface* instPointer,int percent);

/** *
	This function will allow feedback on completion of the script.
	It turns the result as a @ref KScriptInteface::Result, and a return
	value as a @ref QVariant
		
*/
void kde_KScriptClientInterface_done(kde_KScriptClientInterface* instPointer,int result, qt_QVariant * returned);

#endif
