/***************************************************************************
                            kde_KListBox.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KLISTBOX
#define KDE_KLISTBOX

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Extends the functionality of @ref QListBox to honor the system
 wide settings for Single Click/Double Click mode, Auto Selection and
 Change Cursor over Link.

 There is a new signal @ref executed(). It gets connected to either
 @ref QListBox::clicked() or @ref QListBox::doubleClicked()
 depending on the KDE wide Single Click/Double Click settings. It is
 strongly recomended that you use this signal instead of the above
 mentioned. This way you dont need to care about the current
 settings.  If you want to get informed when the user selects
 something connect to the @ref QListBox::selectionChanged() signal.

 @short A variant of @ref QListBox that honors KDE's system-wide settings.

*/
kde_KListBox * kde_new_KListBox(qt_QWidget * parent, char* name, int f);
void kde_KListBox_emitExecute(kde_KListBox* instPointer,qt_QListBoxItem * item, qt_QPoint* pos);
void kde_KListBox_virtual_hook(kde_KListBox* instPointer,int identifier, void* data);
void kde_KListBox_slotOnItem(kde_KListBox* instPointer,qt_QListBoxItem * item);
void kde_KListBox_slotOnViewport(kde_KListBox* instPointer);
void kde_KListBox_slotSettingsChanged(kde_KListBox* instPointer,int arg1);

/** *
 Auto selection happend.
   
*/
void kde_KListBox_slotAutoSelect(kde_KListBox* instPointer);

#endif
