/***************************************************************************
                            kde_KKey.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KKEY
#define KDE_KKEY

#include <qtc/qtc_types.h>
#include <qtc/qt_Qt.h>

#include <kdec/kde_types.h>

#define KKEY_MOD_FLAG_COUNT	4
#define KKEY_QtWIN	(QT_ALT<<1)
#define KKEY_SHIFT	0x01
#define KKEY_CTRL	0x02
#define KKEY_ALT	0x04
#define KKEY_WIN	0x08

/** *
 Creates a new null KKey.

*/
kde_KKey * kde_new_KKey();

/** *
 Creates a new key for the given Qt key code.

*/
kde_KKey * kde_new_KKey1(int keyQt);

/** *
 Creates a new key from the first key code of the given key sequence.

*/
kde_KKey * kde_new_KKey2(qt_QKeySequence* keySeq);

/** *
 Extracts the key from the given key event.

*/
kde_KKey * kde_new_KKey3(qt_QKeyEvent* keyEvent);

/** *
 Copy constructor.
	 
*/
kde_KKey * kde_new_KKey4(kde_KKey* key);

/** *
 Creates a new key from the given description. The form of the description
 is "[modifier+[modifier+]]+key", for example "e", "CTRL+q" or 
 "CTRL+ALT+DEL". Allowed modifiers are "SHIFT", "CTRL", "ALT", "WIN" and
 "META". "WIN" and "META" are equivalent. Modifiers are not case-sensitive. 

*/
kde_KKey * kde_new_KKey5(qt_QString * key);

/** *

	 
*/
kde_KKey * kde_new_KKey6(unsigned int key, unsigned int mod);
void kde_del_KKey( kde_KKey* p );

/** *
 Clears the key. The key is null after calling this function.

*/
void kde_KKey_clear(kde_KKey* instPointer);

/** *
 Initializes the key with the given Qt key code.

*/
int kde_KKey_init(kde_KKey* instPointer,int keyQt);

/** *
 Initializes the key with the first key code of the given key sequence.

*/
int kde_KKey_init1(kde_KKey* instPointer,qt_QKeySequence* keySeq);

/** *
 Initializes the key by extracting the code from the given key event.

*/
int kde_KKey_init2(kde_KKey* instPointer,qt_QKeyEvent* keyEvent);

/** *
 Copies the given key.

*/
int kde_KKey_init3(kde_KKey* instPointer,kde_KKey* key);

/** *
 Initializes the key with the given description. The form of the description
 is "[modifier+[modifier+]]+key", for example "e", "CTRL+q" or 
 "CTRL+ALT+DEL". Allowed modifiers are "SHIFT", "CTRL", "ALT", "WIN" and
 "META". "WIN" and "META" are equivalent. Modifiers are not case-sensitive. 

*/
int kde_KKey_init4(kde_KKey* instPointer,qt_QString * arg1);

/** *

	 
*/
int kde_KKey_init5(kde_KKey* instPointer,unsigned int key, unsigned int mod);

/** *
 Returns true if the key is null (after @ref clear() or empty
 constructor).

*/
int kde_KKey_isNull(kde_KKey* instPointer);

/** *

	 
*/
int kde_KKey_isValidQt(kde_KKey* instPointer);

/** *

	 
*/
int kde_KKey_isValidNative(kde_KKey* instPointer);

/** *

	 
*/
unsigned int kde_KKey_sym(kde_KKey* instPointer);

/** *

	 
*/
unsigned int kde_KKey_modFlags(kde_KKey* instPointer);

/** *
 Compares this key with the given KKey object. Returns a negative 
 number if the given KKey is larger, 0 if they are equal and
 a positive number this KKey is larger. The returned value
 is the difference between the symbol or, if the symbols 
 are equal, the difference between the encoded modifiers.

*/
int kde_KKey_compare(kde_KKey* instPointer,kde_KKey* key);

/** *
 Returns the qt key code.

*/
int kde_KKey_keyCodeQt(kde_KKey* instPointer);

/** *
 Returns a human-readable representation of the key in the form
 "modifier+key".

*/
qt_QString * kde_KKey_toString(kde_KKey* instPointer);

/** *

	 
*/
qt_QString * kde_KKey_toStringInternal(kde_KKey* instPointer);

/** *

	 
*/
void kde_KKey_simplify(kde_KKey* instPointer);

/** *
 Returns a null key.

*/
kde_KKey* kde_KKey_null( );

/** *
 Returns a user-readable representation of the given modifiers.

*/
qt_QString * kde_KKey_modFlagLabel( int f);

#endif
