/***************************************************************************
                            kde_KDialogBase.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDIALOGBASE
#define KDE_KDIALOGBASE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>
#include <kdec/kde_KJanusWidget.h>

/**
*
 Provides basic functionality needed by nearly all dialogs.

 It offers the standard action buttons you'd expect to find in a
 dialog as well as the capability to define at most three configurable
 buttons. You can define a main widget that contains your specific
 dialog layout or you can use a predefined layout. Currently, @p
 TreeList/Paged, @p Tabbed, @p Plain, @p Swallow and @p IconList
 mode layouts (faces) are available.

 The class takes care of the geometry management. You only need to define
 a minimum size for the widget you want to use as the main widget.

 You can set a background tile (pixmap) for parts of the dialog. The
 tile you select is shared by all instances of this class in your
 application so that they all get the same look and feel.

 There is a tutorial available on http://developer.kde.org/ (NOT YET)
 that contains
 copy/paste examples as well a screenshots on how to use this class.

 You select which buttons should be displayed, but you do not choose the
 order in which they are displayed. This ensures a standard interface in
 KDE. The button order can be changed, but this ability is only available
 for a central KDE control tool. The following buttons are available:
 OK, Cancel/Close, Apply/Try, Default, Help and three user definable
 buttons: User1, User1 and User3. You must specify the text of the UserN
 buttons. Each button has a virtual slot so you can overload the method
 when required. The default slots emit a signal as well, so you can choose
 to connect a signal instead of overriding the slot.
 The default implementation of @ref slotHelp() will automatically enable
 the help system if you have provided a path to the help text.
 @ref slotCancel() and @ref slotClose() will run @ref QDialog::reject()
 while @ref slotOk() will run @ref QDialog::accept(). You define a default
 button in the constructor.

 If you don't want any buttons at all because your dialog is special
 in some way, then set the buttonMask argument in the constructor to zero
 (0). The optional button box separator line should not be enabled
 in this case. Note that the KDialogBase will animate a button press
 when the user press Escape. The button that is enabled is either Cancel,
 Close or the button that is defined by @ref setEscapeButton() The
 animation will not take place when the buttonMask is zero. Your
 custom dialog code should reimplement the @ref keyPressEvent and
 animate the cancel button so that the dialog behaves like regular
 dialogs. NOTE: None of the regular slots (like @ref slotOk() ) or
 signals that are related to the standard action buttons will be used
 when you don't use these buttons.

 You can either use one of the prebuilt, easy to use, faces or
 define your own main widget. The dialog provides ready to use
 TreeList, Tabbed, Plain, Swallow and IconList faces. KDialogBase uses
 the @ref KJanusWidget class internally to accomplish this. If you
 use TreeList, Tabbed or IconList mode, then add pages with @ref addPage().

 Pages that have been added can be removed again by simply deleting
 the page.

 If you want complete control of how the dialog contents should look,
 then you can define a main widget by using @ref setMainWidget(). You
 only need to set the minimum size of that widget and the dialog will
 resize itself to fit this minimum size.  The dialog is resizeable, but
 cannot be made smaller than its minimum size.

 The dialog consists of a help area on top (becomes visible if you define
 a help path and use @ref enableLinkedHelp()), the main area which is
 the built-in dialog face or your own widget in the middle and by default
 a button box at the bottom. The button box can also be placed at the
 right edge (to the right of the main widget). Use
 @ref setButtonBoxOrientation() to control this behavior. A separator
 can be placed above the button box (or to the left when the button box
 is at the right edge). Normally you specify that you want a separator
 in the constructor, but you can use @ref enableButtonSeparator() as well.

 The class is derived from @ref KDialog, so you get automatic access to
 the @ref KDialog::marginHint(), @ref KDialog::spacingHint() and the
 extended @ref KDialog::setCaption() method. NOTE: The main widget you
 use will be positioned inside the dialog using a margin (or border)
 equal to @ref KDialog::marginHint(). You shall not add a margin yourself.
 The example below (from kedit) shows how you use the top level widget
 and its layout. The second argument (the border) to @ref QVBoxLayout
 is 0. This situation is valid for @ref addPage , @ref addVBoxPage ,
 @ref addHBoxPage , @ref addGridPage , @ref makeMainWidget ,
 @ref makeVBoxMainWidget , @ref makeHBoxMainWidget and
 @ref makeGridMainWidget as well.

 Example:

 <pre>
 UrlDlg::UrlDlg( QWidget *parent, const QString& caption,
                 const QString& urltext)
   : KDialogBase( parent, "urldialog", true, caption,
		    KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
 {
   QWidget *page = new QWidget( this );
   setMainWidget(page);
   QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

   QLabel *label = new QLabel( caption, page, "caption" );
   topLayout->addWidget( label );

   lineedit = new QLineEdit( urltext, page, "lineedit" );
   lineedit->setMinimumWidth(fontMetrics().maxWidth()*20);
   topLayout->addWidget( lineedit );

   topLayout->addStretch(10);
 }
 </pre>

 If you use @ref makeVBoxMainWidget(), then the dialog above can be made
 simpler but you lose the ability to add a stretchable area:

 <pre>
 UrlDlg::UrlDlg( QWidget *parent, const QString& caption,
		const QString& urltext)
 : KDialogBase( parent, "urldialog", true, caption,
		  KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
 {
   QVBox *page = makeVBoxMainWidget();
   QLabel *label = new QLabel( caption, page, "caption" );

   lineedit = new QLineEdit( urltext, page, "lineedit" );
   lineedit->setMinimumWidth(fontMetrics().maxWidth()*20);
 }
 </pre>

 This class can be used in many ways. Note that most KDE ui widgets
 and many of KDE core applications use the KDialogBase so for more
 inspiration you should study the code for these.

 @author Mirko Boehm (mirko@kde.org) and Espen Sand (espen@kde.org)
 
 @short A dialog base class with standard buttons and predefined layouts.

*/
#define KDIALOGBASE_Help	0x00000001
#define KDIALOGBASE_Default	0x00000002
#define KDIALOGBASE_Ok	0x00000004
#define KDIALOGBASE_Apply	0x00000008
#define KDIALOGBASE_Try	0x00000010
#define KDIALOGBASE_Cancel	0x00000020
#define KDIALOGBASE_Close	0x00000040
#define KDIALOGBASE_User1	0x00000080
#define KDIALOGBASE_User2	0x00000100
#define KDIALOGBASE_User3	0x00000200
#define KDIALOGBASE_No	0x00000080
#define KDIALOGBASE_Yes	0x00000100
#define KDIALOGBASE_Details	0x00000400
#define KDIALOGBASE_Filler	0x40000000
#define KDIALOGBASE_Stretch	0x80000000
#define KDIALOGBASE_ActionStyle0	0
#define KDIALOGBASE_ActionStyle1	0
#define KDIALOGBASE_ActionStyle2	1
#define KDIALOGBASE_ActionStyle3	2
#define KDIALOGBASE_ActionStyle4	3
#define KDIALOGBASE_ActionStyleMAX	4
#define KDIALOGBASE_TreeList	KJANUSWIDGET_TreeList
#define KDIALOGBASE_Tabbed	KJANUSWIDGET_Tabbed
#define KDIALOGBASE_Plain	KJANUSWIDGET_Plain
#define KDIALOGBASE_Swallow	KJANUSWIDGET_Swallow
#define KDIALOGBASE_IconList	KJANUSWIDGET_IconList

/** *
 Constructor for the standard mode where you must specify the main
 widget with @ref setMainWidget() .

*/
kde_KDialogBase * kde_new_KDialogBase(qt_QWidget * parent, char* name, int modal, qt_QString * caption, int buttonMask, int defaultButton, int separator, kde_KGuiItem* user1, kde_KGuiItem* user2, kde_KGuiItem* user3);

/** *
 Constructor for the predefined layout mode where you specify the
 kind of layout (face).

*/
kde_KDialogBase * kde_new_KDialogBase1(int dialogFace, qt_QString * caption, int buttonMask, int defaultButton, qt_QWidget * parent, char* name, int modal, int separator, kde_KGuiItem* user1, kde_KGuiItem* user2, kde_KGuiItem* user3);

/** *
 Constructor for a message box mode where the @p buttonMask can only
 contain Yes, No, or Cancel.

 If you need other names you can rename
 the buttons with @ref setButtonText(). The dialog box is not resizable
 by default but this can be changed by @ref setInitialSize(). If you
 select 'modal' to be true, the dialog will return Yes, No, or Cancel
 when closed otherwise you can use the signals @ref yesClicked(),
 @ref noClicked(), or @ref cancelClicked() to determine the state.

*/
kde_KDialogBase * kde_new_KDialogBase2(qt_QString * caption, int buttonMask, int defaultButton, int escapeButton, qt_QWidget * parent, char* name, int modal, int separator, kde_KGuiItem* yes, kde_KGuiItem* no, kde_KGuiItem* cancel);

/** *
 Destructor.
     
*/
void kde_del_KDialogBase( kde_KDialogBase* p );

/** *
 Sets the orientation of the button box.

 It can be @p Vertical or @p Horizontal. If @p Horizontal
 (default), the button box is positioned at the bottom of the
 dialog. If @p Vertical it will be placed at the right edge of the
 dialog.

*/
void kde_KDialogBase_setButtonBoxOrientation(kde_KDialogBase* instPointer,int orientation);

/** *
 Sets the button that will be activated when the Escape key
 is pressed.

 Normally you should not use this function. By default,
 the Escape key is mapped to either the Cancel or the Close button
 if one of these buttons are defined. The user expects that Escape will
 cancel an operation so use this function with caution.

*/
void kde_KDialogBase_setEscapeButton(kde_KDialogBase* instPointer,int identifier);

/** *
 Adjust the size of the dialog to fit the contents just before
 @ref QDialog::exec() or @ref QDialog::show() is called.

 This method will not be called if the dialog has been explicitly
 resized before showing it.

*/
void kde_KDialogBase_adjustSize(kde_KDialogBase* instPointer);
qt_QSize * kde_KDialogBase_sizeHint(kde_KDialogBase* instPointer);
qt_QSize * kde_KDialogBase_minimumSizeHint(kde_KDialogBase* instPointer);

/** *
 Retrieve the empty page when the predefined layout is used in @p Plain
 mode.

 This widget must used as the toplevel widget of your dialog
 code.

*/
qt_QFrame* kde_KDialogBase_plainPage(kde_KDialogBase* instPointer);

/** *
 Add a page to the dialog when the class is used in @p TreeList ,
 @p IconList or @p Tabbed mode.

 The returned widget must be used as the
 toplevel widget for this particular page.
 Note: The returned frame widget has no
 layout manager associated with it. In order to use it you must
 create a layout yourself as the example below illustrates:

 <pre>
 QFrame *page = addPage( i18n("Layout") );
 QVBoxLayout *topLayout = new QVBoxLayout( page, 0, 6 );
 QLabel *label = new QLabel( i18n("Layout type"), page );
 topLayout->addWidget( label );
 ..
 </pre>

*/
qt_QFrame* kde_KDialogBase_addPage(kde_KDialogBase* instPointer,qt_QString * itemName, qt_QString * header, qt_QPixmap * pixmap);

/** *
 This is like @ref addPage() just above, with the difference that the first
 element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the @p TreeList face. Later this may
 be added for the @p IconList face too. In other faces than the
 @p TreeList, all the strings except the last one is ignored.

*/
qt_QFrame* kde_KDialogBase_addPage1(kde_KDialogBase* instPointer,qt_QStringList* items, qt_QString * header, qt_QPixmap * pixmap);

/** *
 Add a page to the dialog when the class is used in @p TreeList,
 @p IconList or @p Tabbed mode.

 The returned widget must be used as the toplevel widget for
 this particular page. The widget contains a @ref QVBoxLayout
 layout so the widget children are lined up vertically.  You can
 use it as follows:

 <pre>
 QVBox *page = addVBoxPage( i18n("Layout") );
 QLabel *label = new QLabel( i18n("Layout type"), page );
 ..
 </pre>

*/
qt_QVBox* kde_KDialogBase_addVBoxPage(kde_KDialogBase* instPointer,qt_QString * itemName, qt_QString * header, qt_QPixmap * pixmap);

/** *
 This is like @ref addVBoxPage() just above, with the difference
 that the first element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the @p TreeList face. Later this may
 be added for the @p IconList face too. In other faces than the
 @p TreeList, all the strings except the last one is ignored.

*/
qt_QVBox* kde_KDialogBase_addVBoxPage1(kde_KDialogBase* instPointer,qt_QStringList* items, qt_QString * header, qt_QPixmap * pixmap);

/** *
 Add a page to the dialog when the class is used in @p TreeList,
 @p IconList or @p Tabbed mode.

 The returned widget must be used as the
 toplevel widget for this particular page. The widget contains a
 @ref QHBoxLayout layout so the widget children are lined up horizontally.
 You can use it as follows:

*/
qt_QHBox* kde_KDialogBase_addHBoxPage(kde_KDialogBase* instPointer,qt_QString * itemName, qt_QString * header, qt_QPixmap * pixmap);

/** *
 This is like @ref addHBoxPage() just above, with the
 difference that the first element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the @p TreeList face. Later this may
 be added for the @p IconList face too. In other faces than the
 @p TreeList, all the strings except the last one is ignored.

*/
qt_QHBox* kde_KDialogBase_addHBoxPage1(kde_KDialogBase* instPointer,qt_QStringList* items, qt_QString * header, qt_QPixmap * pixmap);

/** *
 Add a page to the dialog when the class is used in @p TreeList,
 @p IconList or @p Tabbed mode.

 The returned widget must be used as the
 toplevel widget for this particular page. The widget contains a
 @ref QGridLayout layout so the widget children are  positioned in a grid.

*/
qt_QGrid* kde_KDialogBase_addGridPage(kde_KDialogBase* instPointer,int n, int dir, qt_QString * itemName, qt_QString * header, qt_QPixmap * pixmap);

/** *
 This is like @ref addGridPage() just above, with the difference
 that the first element is a list of strings.

 These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the @p TreeList face. Later this may
 be added for the @p IconList face too. In other faces than the
 @p TreeList, all the strings except the last one is ignored.

*/
qt_QGrid* kde_KDialogBase_addGridPage1(kde_KDialogBase* instPointer,int n, int dir, qt_QStringList* items, qt_QString * header, qt_QPixmap * pixmap);

/** *
 Sets the icon used in @p TreeList Mode for the given path.

*/
void kde_KDialogBase_setFolderIcon(kde_KDialogBase* instPointer,qt_QStringList* path, qt_QPixmap * pixmap);

/** *
 Make a main widget.

 The function will make a @ref QFrame widget
 and use @ref setMainWidget() to register it. You can @em not use this
 function more than once, @em not if you have already defined a
 main widget with @ref setMainWidget() and @em not if you have used the
 constructor where you define the face (@p Plain, @p Swallow, @p Tabbed,
 @p TreeList).

*/
qt_QFrame* kde_KDialogBase_makeMainWidget(kde_KDialogBase* instPointer);

/** *
 Make a main widget.

 The function will make a @ref QVBox widget
 and use @ref setMainWidget() to register it. You @em can use this
 function more than once, @em not if you have already defined a
 main widget with @ref setMainWidget() and @em not if you have used the
 constructor where you define the face (@p Plain, @p Swallow, @p Tabbed,
 @p TreeList, @p IconList).

*/
qt_QVBox* kde_KDialogBase_makeVBoxMainWidget(kde_KDialogBase* instPointer);

/** *
 Make a main widget.

 The function will make a @ref QHBox widget
 and use @ref setMainWidget() to register it. You can @em not use this
 function more than once, @em not if you have already defined a
 main widget with @ref setMainWidget() and @p not if you have used the
 constructor where you define the face (@p Plain, @p Swallow, @p Tabbed,
 @p TreeList, @p IconList).

*/
qt_QHBox* kde_KDialogBase_makeHBoxMainWidget(kde_KDialogBase* instPointer);

/** *
 Make a main widget.

 The function will make a @ref QGrid widget
 and use @ref setMainWidget() to register it. You can @em not use this
 function more than once, @em not if you have already defined a
 main widget with @ref #setMainWidget and @em not if you have used the
 constructor where you define the face (Plain, Swallow, Tabbed,
 TreeList, IconList).

*/
qt_QGrid* kde_KDialogBase_makeGridMainWidget(kde_KDialogBase* instPointer,int n, int dir);

/** *
 Hide or display the a separator line drawn between the action
 buttons an the main widget.
     
*/
void kde_KDialogBase_enableButtonSeparator(kde_KDialogBase* instPointer,int state);

/** *
 Hide or display a general action button.

  Only buttons that have
 been created in the constructor can be displayed. This method will
 not create a new button.

*/
void kde_KDialogBase_showButton(kde_KDialogBase* instPointer,int identifier, int state);

/** *
 Hide or display the OK button.

  The OK button must have
 been created in the constructor to be displayed.

*/
void kde_KDialogBase_showButtonOK(kde_KDialogBase* instPointer,int state);

/** *
 Hide or display the Apply button.

  The Apply button must have
 been created in the constructor to be displayed.

*/
void kde_KDialogBase_showButtonApply(kde_KDialogBase* instPointer,int state);

/** *
 Hide or display the Cancel button. The Cancel button must have
 been created in the constructor to be displayed.

*/
void kde_KDialogBase_showButtonCancel(kde_KDialogBase* instPointer,int state);

/** *
 Sets the page with @p index to be displayed.

 This method will only
 work when the dialog is using the predefined shape of TreeList,
 IconList or Tabbed.

*/
int kde_KDialogBase_showPage(kde_KDialogBase* instPointer,int index);

/** *
 Returns the index of the active page.

 This method will only work when the dialog is using the
 predefined shape of Tabbed, TreeList or IconList.

*/
int kde_KDialogBase_activePageIndex(kde_KDialogBase* instPointer);

/** *
 Returns the index of a page created with @ref #addPage(),
 @ref #addVBoxPage(), @ref addHBoxPage() or @ref #addGridPage().
 You can can compare this index with the value returned from
 @ref #activePageIndex() if you need to do some page specific actions
 in your code.

 The returned index will never change so you can safely use this
 function once and save the value.

*/
int kde_KDialogBase_pageIndex(kde_KDialogBase* instPointer,qt_QWidget * widget);

/** *
 Sets the main user definable widget.

 If the dialog is using the predefined Swallow mode, the widget will
 be reparented to the internal swallow control widget. If the dialog
 is being used in the standard mode then the @p widget must have the
 dialog as parent.

*/
void kde_KDialogBase_setMainWidget(kde_KDialogBase* instPointer,qt_QWidget * widget);

/** *
 Returns the main widget if any.

*/
qt_QWidget * kde_KDialogBase_mainWidget(kde_KDialogBase* instPointer);

/** *
 Convenience method.

  Freezes the dialog size using the minimum size
 of the dialog. This method should only be called right before
 @ref show() or @ref exec().
     
*/
void kde_KDialogBase_disableResize(kde_KDialogBase* instPointer);

/** *
 Convenience method. Sets the initial dialog size.

  This method should
 only be called right before @ref show() or @ref exec(). The initial
 size will be
 ignored if smaller than the dialog's minimum size.

*/
void kde_KDialogBase_setInitialSize(kde_KDialogBase* instPointer,qt_QSize * s, int noResize);

/** *
 Convenience method. Add a size to the default minimum size of a
 dialog.

 This method should only be called right before @ref show() or
 @ref exec().

*/
void kde_KDialogBase_incInitialSize(kde_KDialogBase* instPointer,qt_QSize * s, int noResize);

/** *
 read the dialogs size from the configuration according to the screen size.
 If no size is saved for one dimension of the screen, a default size
 is choosed. The default width is 50 percent of the screen width, the
 default height is 40 percent of the screen height.

*/
qt_QSize * kde_KDialogBase_configDialogSize(kde_KDialogBase* instPointer,qt_QString * groupName);

/** *
 save the dialogs size dependant on the screen dimension either to the
 global or application config file.

*/
void kde_KDialogBase_saveDialogSize(kde_KDialogBase* instPointer,qt_QString * groupName, int global);

/** *
 Sets the text of the OK button.

 If the default parameters are used
 (that is, if no parameters are given) the standard texts are set:
 The button shows "OK", the tooltip contains "Accept settings."
 (internationalized) and the quickhelp text explains the standard
 behavior of the OK button in settings dialogs.

*/
void kde_KDialogBase_setButtonOKText(kde_KDialogBase* instPointer,qt_QString * text, qt_QString * tooltip, qt_QString * quickhelp);

/** *
 Sets the text of the Apply button.

 If the default parameters are
 used (that is, if no parameters are given) the standard texts are set:
 The button shows "Apply", the tooltip contains "Apply settings."
 (internationalized) and the quickhelp text explains the standard
 behavior of the apply button in settings dialogs.

*/
void kde_KDialogBase_setButtonApplyText(kde_KDialogBase* instPointer,qt_QString * text, qt_QString * tooltip, qt_QString * quickhelp);

/** *
 Sets the text of the Cancel button.

  If the default parameters are
 used (that is, if no parameters are given) the standard texts are set:
 The button shows "Cancel", everything else will not be set.

*/
void kde_KDialogBase_setButtonCancelText(kde_KDialogBase* instPointer,qt_QString * text, qt_QString * tooltip, qt_QString * quickhelp);

/** *
 Sets the text of any button.

*/
void kde_KDialogBase_setButtonText(kde_KDialogBase* instPointer,int identifier, qt_QString * text);

/** *
 Sets the tooltip text of any button.

*/
void kde_KDialogBase_setButtonTip(kde_KDialogBase* instPointer,int identifier, qt_QString * text);

/** *
 Sets the "What's this?" text of any button.

*/
void kde_KDialogBase_setButtonWhatsThis(kde_KDialogBase* instPointer,int identifier, qt_QString * text);

/** *
 This function has only effect in TreeList mode.

 Defines how the tree list widget is resized when the dialog is
 resized horizontally. By default the tree list keeps its width
 when the dialog becomes wider.

*/
void kde_KDialogBase_setTreeListAutoResize(kde_KDialogBase* instPointer,int state);

/** *
 This function has only effect in TreeList mode.

 This tells the widgets whether the icons given in the @ref addPage,
 @ref addVBoxPage, @ref addHBoxPage, or @ref addGridPage methods should
 be shown in the TreeList.

 Note: This method must be called before calling any of the methods
 which add icons to the page.

*/
void kde_KDialogBase_setShowIconsInTreeList(kde_KDialogBase* instPointer,int state);

/** *
 This function has only effect in TreeList mode.

 This tells the widgets whether the root should be decorated.
 For details see @ref QListView::setRootIsDecorated

*/
void kde_KDialogBase_setRootIsDecorated(kde_KDialogBase* instPointer,int state);

/** *
 This function has only effect in IconList mode.

 Defines how the icon list widget is displayed. By default it is
 the widgets in the dialog pages that decide the minimum height
 of the dialog. A vertical scrollbar can be used in the icon list
 area.

*/
void kde_KDialogBase_setIconListAllVisible(kde_KDialogBase* instPointer,int state);

/** *
 Enable hiding of the background tile (if any).

*/
void kde_KDialogBase_showTile(kde_KDialogBase* instPointer,int state);

/** *

 Do not use this method. It is included for compatibility reasons.

 This method returns the border widths in all directions the dialog
 needs for itself. Respect this, or get bad looking results.
 The references are upper left x (@p ulx), upper left y (@p uly),
 lower right x (@p lrx), and lower left y (@p lly).
 The results are differences in pixels from the
 dialogs corners.
     
*/
void kde_KDialogBase_getBorderWidths(kde_KDialogBase* instPointer,int ulx, int uly, int lrx, int lry);

/** *

 Do not use this method. It is included for compatibility reasons.

 This method returns the contents rectangle of the work area. Place
 your widgets inside this rectangle, and use it to set up
 their geometry. Be careful: The rectangle is only valid after
 resizing the dialog, as it is a result of the resizing process.
 If you need the "overhead" the dialog needs for its elements,
 use @ref getBorderWidths().
     
*/
qt_QRect* kde_KDialogBase_getContentsRect(kde_KDialogBase* instPointer);

/** *
 Calculate the size hint for the dialog.

 With this method it is easy to calculate a size hint for a
 dialog derived from KDialogBase if you know the width and height of
 the elements you add to the widget. The rectangle returned is
 calculated so that all elements exactly fit into it. Thus, you may
 set it as a minimum size for the resulting dialog.

 You should not need to use this method and never if you use one of
 the predefined shapes.

*/
qt_QSize * kde_KDialogBase_calculateSize(kde_KDialogBase* instPointer,int w, int h);

/** *
 Returns the help link text.

  If no text has been defined,
 "Get help..." (internationalized) is returned.

*/
qt_QString * kde_KDialogBase_helpLinkText(kde_KDialogBase* instPointer);

/** *
 Returns the action button that corresponds to the @p id.

 Normally
 you should not use this function. @em Never delete the object returned
 by this function. See also @ref enableButton(), @ref showButton(),
 @ref setButtonTip(), @ref setButtonWhatsThis(), and @ref setButtonText().

     
*/
qt_QPushButton* kde_KDialogBase_actionButton(kde_KDialogBase* instPointer,int identifier);

/** *
 Enable or disable (gray out) a general action button.

*/
void kde_KDialogBase_enableButton(kde_KDialogBase* instPointer,int identifier, int state);

/** *
 Enable or disable (gray out) the OK button.

*/
void kde_KDialogBase_enableButtonOK(kde_KDialogBase* instPointer,int state);

/** *
 Enable or disable (gray out) the Apply button.

*/
void kde_KDialogBase_enableButtonApply(kde_KDialogBase* instPointer,int state);

/** *
 Enable or disable (gray out) the Cancel button.

*/
void kde_KDialogBase_enableButtonCancel(kde_KDialogBase* instPointer,int state);

/** *
 Display or hide the help link area on the top of the dialog.

*/
void kde_KDialogBase_enableLinkedHelp(kde_KDialogBase* instPointer,int state);

/** *
 Destruct the Dialog delayed.

 You can call this function from
 slots like @ref closeClicked() and @ref hidden().
 You should not use the dialog any more after
 calling this function.

*/
void kde_KDialogBase_delayedDestruct(kde_KDialogBase* instPointer);

/** *
 Sets the text that is shown as the linked text.

 If text is empty,
 the text "Get help..." (internationalized) is used instead.

*/
void kde_KDialogBase_setHelpLinkText(kde_KDialogBase* instPointer,qt_QString * text);

/** *
 Sets the help path and topic.

*/
void kde_KDialogBase_setHelp(kde_KDialogBase* instPointer,qt_QString * anchor, qt_QString * appname);

/** *
 Connected to help link label.
     
*/
void kde_KDialogBase_helpClickedSlot(kde_KDialogBase* instPointer,qt_QString * arg1);

/** *
 Sets the status of the Details button.
     
*/
void kde_KDialogBase_setDetails(kde_KDialogBase* instPointer,int showDetails);

/** *
 Sets the widget that gets shown when "Details" is enabled.

 The dialog takes over ownership of the widget.
 Any previously set widget gets deleted.
     
*/
void kde_KDialogBase_setDetailsWidget(kde_KDialogBase* instPointer,qt_QWidget * detailsWidget);

/** *
 This method is called automatically whenever the background has
 changed. You do not need to use this method.
     
*/
void kde_KDialogBase_updateBackground(kde_KDialogBase* instPointer);

/** *
 Force closing the dialog, setting its result code to the one Esc would set.
 You shouldn't use this, generally (let the user make his choice!)
 but it can be useful when you need to make a choice after a timeout
 has happened, or when the parent widget has to go somewhere else
 (e.g. html redirections).

*/
void kde_KDialogBase_cancel(kde_KDialogBase* instPointer);

/** *
 Check whether the background tile is set or not.

*/
int kde_KDialogBase_haveBackgroundTile( );

/** *
 Returns a pointer to the background tile if there is one.

*/
qt_QPixmap * kde_KDialogBase_backgroundTile( );

/** *

 Use @ref backgroundTile() instead.
     
*/
qt_QPixmap * kde_KDialogBase_getBackgroundTile( );

/** *
 Sets the background tile.

  If it is Null (0), the background image is deleted.

*/
void kde_KDialogBase_setBackgroundTile( qt_QPixmap * pix);

/** *
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/

/** *
 Emits the #hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/

/** *
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
void kde_KDialogBase_virtual_hook(kde_KDialogBase* instPointer,int identifier, void* data);

/** *
 Activated when the Help button has been clicked. If a help
 text has been defined, the help system will be activated.
     
*/
void kde_KDialogBase_slotHelp(kde_KDialogBase* instPointer);

/** *
 Activated when the Default button has been clicked.
     
*/
void kde_KDialogBase_slotDefault(kde_KDialogBase* instPointer);

/** *
 Activated when the Details button has been clicked.

*/
void kde_KDialogBase_slotDetails(kde_KDialogBase* instPointer);

/** *
 Activated when the User3 button has been clicked.
     
*/
void kde_KDialogBase_slotUser3(kde_KDialogBase* instPointer);

/** *
 Activated when the User2 button has been clicked.
     
*/
void kde_KDialogBase_slotUser2(kde_KDialogBase* instPointer);

/** *
 Activated when the User1 button has been clicked.
     
*/
void kde_KDialogBase_slotUser1(kde_KDialogBase* instPointer);

/** *
 Activated when the Ok button has been clicked. The
 @ref QDialog::accept() is activated.
     
*/
void kde_KDialogBase_slotOk(kde_KDialogBase* instPointer);

/** *
 Activated when the Apply button has been clicked.
     
*/
void kde_KDialogBase_slotApply(kde_KDialogBase* instPointer);

/** *
 Activated when the Try button has been clicked.
     
*/
void kde_KDialogBase_slotTry(kde_KDialogBase* instPointer);

/** *
 Activated when the Yes button has been clicked. The
 @ref QDialog::done( Yes ) is activated.
     
*/
void kde_KDialogBase_slotYes(kde_KDialogBase* instPointer);

/** *
 Activated when the Yes button has been clicked. The
 @ref QDialog::done( No ) is activated.
     
*/
void kde_KDialogBase_slotNo(kde_KDialogBase* instPointer);

/** *
 Activated when the Cancel button has been clicked. The
 @ref QDialog::reject() is activated in regular mode and
 @ref QDialog::done( Cancel ) when in message box mode.
     
*/
void kde_KDialogBase_slotCancel(kde_KDialogBase* instPointer);

/** *
 Activated when the Close button has been clicked. The
 @ref QDialog::reject() is activated.
     
*/
void kde_KDialogBase_slotClose(kde_KDialogBase* instPointer);

/** *
 Do not use this slot. Is is kept for compatibility reasons.
 Activated when the Apply button has been clicked
     
*/
void kde_KDialogBase_applyPressed(kde_KDialogBase* instPointer);

/** *
 Updates the margins and spacings.
     
*/
void kde_KDialogBase_updateGeometry(kde_KDialogBase* instPointer);

/** *
 Deletes the dialog immediately. If you want to delete the dialog
 delayed use delayedDestruct() or QObject::deleteLater().

 Attention: Do no use connect this slot to signals from user
 actions!
     
*/
void kde_KDialogBase_slotDelayedDestruct(kde_KDialogBase* instPointer);

#endif
