/***************************************************************************
                            kde_HTMLFormElement.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLFORMELEMENT
#define KDE_HTMLFORMELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The <code> FORM </code> element encompasses behavior similar to a
 collection and an element. It provides direct access to the
 contained input elements as well as the attributes of the form
 element. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-FORM">
 FORM element definition </a> in HTML 4.0.

 
 @short *
 The <code> FORM </code> element encompasses behavior similar to a
 collection and an element.
*/
kde_HTMLFormElement * kde_new_HTMLFormElement();
kde_HTMLFormElement * kde_new_HTMLFormElement1(kde_HTMLFormElement* other);
kde_HTMLFormElement * kde_new_HTMLFormElement2(kde_DOMNode* other);
void kde_del_HTMLFormElement( kde_HTMLFormElement* p );

/** *
 Returns a collection of all control elements in the form.

     
*/
kde_HTMLCollection* kde_HTMLFormElement_elements(kde_HTMLFormElement* instPointer);

/** *
 The number of form controls in the form.

     
*/
long kde_HTMLFormElement_length(kde_HTMLFormElement* instPointer);

/** *
 Names the form.

     
*/
kde_DOMString* kde_HTMLFormElement_name(kde_HTMLFormElement* instPointer);

/** *
 see @ref name
     
*/
void kde_HTMLFormElement_setName(kde_HTMLFormElement* instPointer,kde_DOMString* arg1);

/** *
 List of character sets supported by the server. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accept-charset">
 accept-charset attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFormElement_acceptCharset(kde_HTMLFormElement* instPointer);

/** *
 see @ref acceptCharset
     
*/
void kde_HTMLFormElement_setAcceptCharset(kde_HTMLFormElement* instPointer,kde_DOMString* arg1);

/** *
 Server-side form handler. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-action">
 action attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFormElement_action(kde_HTMLFormElement* instPointer);

/** *
 see @ref action
     
*/
void kde_HTMLFormElement_setAction(kde_HTMLFormElement* instPointer,kde_DOMString* arg1);

/** *
 The content type of the submitted form, generally
 "application/x-www-form-urlencoded". See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-enctype">
 enctype attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFormElement_enctype(kde_HTMLFormElement* instPointer);

/** *
 see @ref enctype
     
*/
void kde_HTMLFormElement_setEnctype(kde_HTMLFormElement* instPointer,kde_DOMString* arg1);

/** *
 HTTP method used to submit form. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-method">
 method attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFormElement_method(kde_HTMLFormElement* instPointer);

/** *
 see @ref method
     
*/
void kde_HTMLFormElement_setMethod(kde_HTMLFormElement* instPointer,kde_DOMString* arg1);

/** *
 Frame to render the resource in. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-target">
 target attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLFormElement_target(kde_HTMLFormElement* instPointer);

/** *
 see @ref target
     
*/
void kde_HTMLFormElement_setTarget(kde_HTMLFormElement* instPointer,kde_DOMString* arg1);

/** *
 Submits the form. It performs the same action as a submit
 button.

     
*/
void kde_HTMLFormElement_submit(kde_HTMLFormElement* instPointer);

/** *
 Restores a form element's default values. It performs the same
 action as a reset button.

     
*/
void kde_HTMLFormElement_reset(kde_HTMLFormElement* instPointer);

#endif
