/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [TEPty.h]                 Pseudo Terminal Device                           */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997,1998 by Lars Doelle <lars.doelle@on-line.de>            */
/*                                                                            */
/* This file is part of Konsole - an X terminal for KDE                       */
/*                                                                            */
/* -------------------------------------------------------------------------- */

/*! \file
*/

#ifndef TE_PTY_H
#define TE_PTY_H

#include <config.h>
#include <sys/types.h>
#include <sys/ioctl.h>

#include <kprocess.h>
#include <termios.h>
#include <qsocketnotifier.h>
#include <qtimer.h>
#include <qstrlist.h>
#include <qvaluelist.h>
#include <qmemarray.h>

class TEPty: public KProcess
{
Q_OBJECT

  public:

    TEPty();
    ~TEPty();

  public:

    /*!
     * having a `run' separate from the constructor allows to make
     * the necessary connections to the signals and slots of the
     * instance before starting the execution of the client.
     */
    int run( const char* pgm, QStrList & args, const char* term, bool _addutmp,
             const char* konsole_dcop = "", const char* konsole_dcop_session = "" );
    void setWriteable(bool writeable);
    void setXonXoff(bool _xonxoff) { m_bXonXoff = _xonxoff; }
    int makePty(bool _addutmp);
    int masterFd() { return m_MasterFd; }
    QString error() { return m_strError; }

  public slots:
    void lockPty(bool lock);
    void send_bytes(const char* s, int len);
    void setSize(int lines, int columns);

  signals:

    /*!
        emitted when the client program terminates.
        \param status the wait(2) status code of the terminated client program.
    */
    void done(int status);

    /*!
        emitted when a new block of data comes in.
        \param s - the data
        \param len - the length of the block
    */
    void block_in(const char* s, int len);

  public:

    void send_byte(char s);
    void send_string(const char* s);

    const char* deviceName();

    virtual void commClose();
    
  protected:
      virtual int commSetupDoneC();
      virtual int setupCommunication(Communication comm);
  
  protected slots:
      void DataReceived(int, int& len);
  public slots:
      void donePty();
      
  private:
    void startPgm(const char* pgm, QValueList<QCString> & args, const char* term);
    void openPty();
    void appendSendJob(const char* s, int len);

  private slots:
    void doSendJobs();

  private:

    struct winsize m_WSize;
    int m_MasterFd;
    int m_SlaveFd;
    bool             m_bNeedGrantPty;
    bool             m_bXonXoff;
    bool             m_bAddUtmp;
    char ptynam[50]; // "/dev/ptyxx" | "/dev/ptmx"
    char ttynam[50]; // "/dev/ttyxx" | "/dev/pts/########..."
    const char *pgm;
    QString m_strError;

    // environment variables
    const char *term;
    const char *konsole_dcop;
    const char *konsole_dcop_session;

    struct SendJob {
      SendJob() {}
      SendJob(const char* b, int len) {
        buffer.duplicate(b,len);
        start = 0;
        length = len;
      }
      QMemArray<char> buffer;
      int start;
      int length;
    };
    QValueList<SendJob> pendingSendJobs;
    QTimer* pSendJobTimer;

  friend int chownpty(int, bool);
};

#endif
