/***************************************************************************
                          mediacontrol.h  -  description
                             -------------------
    begin                : Tue Apr 25 11:53:11 CEST 2000
    copyright            : (C) 2000 by Stefan Gehn
    email                : sgehn@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MEDIACONTROL_H
#define MEDIACONTROL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <klocale.h>
#include <kpanelapplet.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kaboutdata.h>
#include <kaboutapplication.h>

// used for the applet itself
#include <qpushbutton.h>
#include <qslider.h>
#include <qtimer.h>

// used in about
#include <qlabel.h>

// used everywhere :)
#include <qstring.h>

#include "playerInterface.h"
#include "configfrontend.h"
#include "mediacontroliface.h"

class KInstance;
class MediaControlConfig;
// ===============================================================

class TrayButton : public QPushButton
{
    Q_OBJECT

public:
    TrayButton(QWidget* parent, const char* name)
        : QPushButton (parent, name) { setBackgroundMode( PaletteBackground ); }
    virtual ~TrayButton() {}

protected:
    void drawButton(QPainter *p);
};

// ===============================================================

class MediaControl : public KPanelApplet, virtual public MediaControlIface
{
	Q_OBJECT

	public:

		MediaControl(const QString& , Type , int , QWidget * = 0, const char * = 0);
		virtual ~MediaControl();

		void about();
		void preferences();
		int widthForHeight (int height) const;
		int heightForWidth (int width) const;
		void dragEnterEvent ( QDragEnterEvent* event );
		void dropEvent ( QDropEvent* event );
		virtual void reparseConfig();

	private:
		KInstance         *_instance;
		DCOPClient        *_dcopClient;
		PlayerInterface   *_player;
		ConfigFrontend    *_configFrontend;
		MediaControlConfig *_prefsDialog;
		TrayButton       *prev_button;  // GoTo Previous Playlist-Item
		TrayButton       *play_button;  // Start playing
		TrayButton       *pause_button; // Pause playing
		TrayButton       *stop_button;  // Stop the music
		TrayButton       *next_button;  // GoTo Next Playlist-Item
		QSlider           *time_slider;
		int lastLen, lastTime;
		void resizeEvent( QResizeEvent* );

		friend class MediaControlToolTip;
		MediaControlToolTip *slider_tooltip;

	private slots:
		void setSliderPosition(int len, int time);
		void slotIconChanged(int=0);
		void disableAll(void);
		void enableAll(void);
		void slotClosePrefsDialog( void );
		void slotPrefsDialogClosing( void );
		void slotConfigChanged();
};

#endif
