/*******************************************************************
*                                                                  *
*             This software is part of the ast package             *
*                Copyright (c) 1986-2001 AT&T Corp.                *
*        and it may only be used by you under license from         *
*                       AT&T Corp. ("AT&T")                        *
*         A copy of the Source Code Agreement is available         *
*                at the AT&T Internet web site URL                 *
*                                                                  *
*       http://www.research.att.com/sw/license/ast-open.html       *
*                                                                  *
*        If you have copied this software without agreeing         *
*        to the terms of the license you are infringing on         *
*           the license and copyright and are violating            *
*               AT&T's intellectual property rights.               *
*                                                                  *
*                 This software was created by the                 *
*                 Network Services Research Center                 *
*                        AT&T Labs Research                        *
*                         Florham Park NJ                          *
*                                                                  *
*               Glenn Fowler <gsf@research.att.com>                *
*******************************************************************/
#pragma prototyped
/*
 * Glenn Fowler
 * AT&T Research
 *
 * preprocessor C language reserved keyword token table
 * for use by PP_COMPILE
 *
 * "-" keywords entered without SYM_KEYWORD
 * "+" keywords entered without SYM_KEYWORD unless PP_PLUSPLUS was set
 * upper case are pseudo keywords for PP_RESERVED token classes
 */

#include "pplib.h"
#include "ppkey.h"

struct ppkeyword	ppkey[] =
{
	"auto",		T_AUTO,
	"break",	T_BREAK,
	"case",		T_CASE,
	"char",		T_CHAR,
	"continue",	T_CONTINUE,
	"default",	T_DEFAULT,
	"do",		T_DO,
	"double",	T_DOUBLE_T,
	"else",		T_ELSE,
	"extern",	T_EXTERN,
	"float",	T_FLOAT_T,
	"for",		T_FOR,
	"goto",		T_GOTO,
	"if",		T_IF,
	"int",		T_INT,
	"long",		T_LONG,
	"register",	T_REGISTER,
	"return",	T_RETURN,
	"short",	T_SHORT,
	"sizeof",	T_SIZEOF,
	"static",	T_STATIC,
	"struct",	T_STRUCT,
	"switch",	T_SWITCH,
	"typedef",	T_TYPEDEF,
	"union",	T_UNION,
	"unsigned",	T_UNSIGNED,
	"while",	T_WHILE,
	"-const",	T_CONST,
	"-enum",	T_ENUM,
	"-signed",	T_SIGNED,
	"-void",	T_VOID,
	"-volatile",	T_VOLATILE,
	"+asm",		T_ASM,
	"+class",	T_CLASS,
	"+delete",	T_DELETE,
	"+friend",	T_FRIEND,
	"+inline",	T_INLINE,
	"+new",		T_NEW,
	"+operator",	T_OPERATOR,
	"+overload",	T_OVERLOAD,
	"+private",	T_PRIVATE,
	"+public",	T_PUBLIC,
	"+this",	T_THIS,
	"+virtual",	T_VIRTUAL,
	"-and",		T_ANDAND,
	"-and_eq",	T_ANDEQ,
	"-bitand",	'&',
	"-bitor",	'|',
	"-bool",	T_BOOL,
	"-catch",	T_CATCH,
	"-compl",	'~',
	"-const_cast",	T_CONST_CAST,
	"-dynamic_cast",T_DYNAMIC_CAST,
	"-explicit",	T_EXPLICIT,
	"-false",	T_FALSE,
	"-mutable",	T_MUTABLE,
	"-namespace",	T_NAMESPACE,
	"-not",		'!',
	"-not_eq",	T_NE,
	"-or",		T_OROR,
	"-or_eq",	T_OREQ,
	"-protected",	T_PROTECTED,
	"-reinterpret_cast", T_REINTERPRET_CAST,
	"-static_cast",	T_STATIC_CAST,
	"-template",	T_TEMPLATE,
	"-throw",	T_THROW,
	"-true",	T_TRUE,
	"-try",		T_TRY,
	"-typeid",	T_TYPEID,
	"-using",	T_USING,
	"-wchar_t",	T_WCHAR_T,
	"-xor",		'^',
	"-xor_eq",	T_XOREQ,
	"-int64",	T_INT64,
	"-NOISES",	T_NOISES,
	"-NOISE",	T_NOISE,
	"-GROUP",	T_X_GROUP,
	"-LINE",	T_X_LINE,
	"-STATEMENT",	T_X_STATEMENT,
	0, 0, 0
};
