
#include "xmlbugjob.h"

#include <kio/job.h>

#include <string.h>
#include <klocale.h>
#include <kdebug.h>

XmlBugJob::XmlBugJob( BugServer *server )
    : Job( false ), mServer( server )
{
}

XmlBugJob::~XmlBugJob()
{
}

void XmlBugJob::start( const KURL &url )
{
    kdDebug() << "XmlBugJob::start(): " << url.url() << endl;

    // ### obey post, if necessary

    KIO::Job *job = KIO::get( url, true /*always 'reload=true', we have our own cache*/, false );

    connect( job, SIGNAL( result( KIO::Job * ) ),
             this, SLOT( ioResult( KIO::Job * ) ) );
    connect( job, SIGNAL( data( KIO::Job *, const QByteArray & ) ),
             this, SLOT( ioData( KIO::Job *, const QByteArray & ) ) );
    connect( job, SIGNAL( infoMessage( KIO::Job *, const QString & ) ),
             this, SLOT( ioInfoMessage( KIO::Job *, const QString & ) ) );
    connect( job, SIGNAL( percent( KIO::Job *, unsigned long ) ),
             this, SLOT( ioInfoPercent( KIO::Job *, unsigned long ) ) );
}

void XmlBugJob::ioResult( KIO::Job *job )
{
    m_error = job->error();
    m_errorText = job->errorText();

    if ( job->error() )
    {
        emit error( m_errorText );
        delete this;
        return;
    }


    infoMessage( i18n( "Parsing..." ) );

#if 0
    kdDebug() << "--START:" << m_data << ":END--" << endl;
#endif

    process( m_data );
    infoMessage( i18n( "Ready." ) );

    delete this;
}

void XmlBugJob::ioData( KIO::Job *, const QByteArray &data )
{
    unsigned int start = m_data.size();

    m_data.resize( m_data.size() + data.size() );
    memcpy( m_data.data() + start, data.data(), data.size() );
}

void XmlBugJob::ioInfoMessage( KIO::Job *, const QString &_text )
{
    QString text = _text;
    emit infoMessage( text );
}

void XmlBugJob::ioInfoPercent( KIO::Job *, unsigned long percent )
{
    emit infoPercent( percent );
}

#include "xmlbugjob.moc"

/*
 * vim:sw=4:ts=4:et
 */
