#ifndef KSYNCVIEW_H
#define KSYNCVIEW_H

#include <qptrlist.h>
#include <qwidget.h>

#include <ktempfile.h>
#include <kurl.h>
#include <kio/job.h>
#include <kdebug.h>

#include <ksyncer.h>

class QListView;
class QCheckBox;
class QComboBox;
class QPushButton;
class KConfig;
class KURLRequester;

class KSyncer;


/** The KSyncView class provides the view widget for the KSyncApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KSyncView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KSyncApp class to manipulate and display
 * the document structure provided by the KSyncDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KSyncView : public QWidget
{
    Q_OBJECT
  public:
    /** Constructor for the main view */
    KSyncView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~KSyncView();

    enum { TypeCalendar, TypeBookmarks, TypeAddressBook };

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);

    void readConfig(KConfig *);
    void readTypeConfig(KConfig *);
    void writeConfig(KConfig *);
    void writeTypeConfig(KConfig *);

    void synceeLoadError();
    void synceeLoaded();

  private slots:
    void addSource();
    void removeSource();
    void showSource();
    void doSync();
    void checkSyncBack();
    void reloadSyncees();
    void finishSync();
    void jobFinished(KIO::Job *job);
    void slotSelectionChanged();  
  private:
    void checkFinish();
    KSyncee *createSyncee(const KURL &);
    QString createTempFile();
    
    QListView *mSourceListView;
    QComboBox *mTypeCombo;
    KURLRequester *mTargetReq;
    QCheckBox *mSyncBackCheck;
    
    int mCurrentType;
    
    KSyncer *mSyncer;
    KSyncee *mTarget;
    QPtrList<KTempFile> mTmpFiles;
    int mLoadCount;
    bool mLoadError;
    QPushButton *showButton,*removeButton;
};


class SynceeLoader : public QObject
{
    Q_OBJECT
  public:
    SynceeLoader(KSyncView *parent,KSyncee *syncee,const QString &filename) :
      mSyncee(syncee), mParent(parent)
    {
      mSyncee->setFilename(filename);
    }
    virtual ~SynceeLoader() {}
    
  public slots:
    void loadSyncee(KIO::Job *job)
    {
      if (job->error()) {
        job->showErrorDialog(mParent);
        mParent->synceeLoadError();
      } else {
        loadSyncee();
        mParent->synceeLoaded();
      }
      delete this;
    }
    
    void loadSyncee()
    {
      kdDebug() << "SynceeLoader::loadSyncee(): " << mSyncee->filename()
                << endl;
      if (!mSyncee->load()) {
        mParent->synceeLoadError();
      }
    }
    
  private:
    KSyncee *mSyncee;
    KSyncView *mParent;
};

#endif // KSYNCVIEW_H
