/***************************************************************************
                          kcontroladdedit.cpp  -  description
                             -------------------
    begin                : Sun May 27 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcontroladdedit.h"
#include "kcontroladdedit.moc"

#include <klocale.h>
#include <kstandarddirs.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <kglobal.h>

#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>

KControlAddEdit::KControlAddEdit(QWidget *parent, const char *name, bool modal, WFlags f) : KWizard(parent, name, modal, f)
{
    setPageQuestion();
    setPageAnswer();
    configRead();
}

KControlAddEdit::~KControlAddEdit()
{
}

/** Init _keducaFile pointer and EditMode */
void KControlAddEdit::init(FileRead *keducaFile, bool edit)
{
    _keducaFile = keducaFile;
    _editMode = edit;

    if( _editMode )
    {
        this->setCaption(i18n("Modify Question"));
        fillPage();
    }else{
        this->setCaption(i18n("Add Questions"));
        slotQuestionType( 0 );
    }
}

/** Fill page of current record */
void KControlAddEdit::fillPage()
{
    _questionText->setText( 		_keducaFile->getQuestion( FileRead::QF_TEXT ) 		);
    if( !_keducaFile->getQuestion( FileRead::QF_PICTURE ).isEmpty() )
    {
        _questionPreview1->setPixmap(_keducaFile->getQuestion(FileRead::QF_PICTURE));
        _questionPreview2->setPixmap(_keducaFile->getQuestion(FileRead::QF_PICTURE));
        _questionPicture->setURL(	_keducaFile->getQuestion( FileRead::QF_PICTURE ) );
    }
    _questionType->setCurrentItem( _keducaFile->getQuestionInt( FileRead::QF_TYPE )-1 );
    slotQuestionType( _questionType->currentItem() );
    _questionPoint->setValue( 		_keducaFile->getQuestionInt( FileRead::QF_POINTS )	);
    _questionTip->setText( 			_keducaFile->getQuestion( FileRead::QF_TIP ) 		);
    _questionExplain->setText( 	_keducaFile->getQuestion( FileRead::QF_EXPLAIN ) );
    _questionTime->setValue( 		_keducaFile->getQuestionInt( FileRead::QF_TIME )	);

    _keducaFile->recordAnswerFirst();
    while( !_keducaFile->recordAnswerEOF() )
    {
        AnswerCopy tmp;
        tmp.text = _keducaFile->getAnswer( FileRead::AF_TEXT );
        tmp.result = _keducaFile->getAnswerValue();
        tmp.points = _keducaFile->getAnswerPoints();
        _answerCopy.append( tmp );
        _keducaFile->recordAnswerNext();
    };
    refreshAnswer_list();
}

/** Refresh klistview of answers */
void KControlAddEdit::refreshAnswer_list()
{
    _listAnswers->clear();

    QValueListIterator<AnswerCopy> it;
    for( it = _answerCopy.begin(); it != _answerCopy.end(); ++it )
    {
        if( (*it).result )
            (void)new QListViewItem( _listAnswers, _listAnswers->lastItem(), (*it).text, i18n("True"), QString().setNum( (*it).points) );
        else
            (void)new QListViewItem( _listAnswers, _listAnswers->lastItem(), (*it).text, i18n("False"), QString().setNum((*it).points) );
    }
}
/** Button insert */
void KControlAddEdit::slot_ButtonAdd()
{
    if( !_answerText->text().isEmpty() )
    {
        AnswerCopy tmp;
        tmp.text = _answerText->text();
        if( _answerValue->currentItem() == 1 )
        {
            tmp.result = true;
            (void)new QListViewItem( _listAnswers, _listAnswers->lastItem(), _answerText->text(), i18n("True"), QString().setNum(_answerPoints->value()) );
        } else {
            tmp.result = false;
            (void)new QListViewItem( _listAnswers, _listAnswers->lastItem(), _answerText->text(), i18n("False"), QString().setNum(_answerPoints->value()) );
        }
        tmp.points = _answerPoints->value();
        _answerCopy.append( tmp );

        _answerText->setText("");
        _answerValue->setCurrentItem( 0 );
        _answerPoints->setValue(0);
        _answerText->setFocus();
    }
}

/** Remove answer */
void KControlAddEdit::slot_ButtonRemove()
{
    QListViewItem *item = _listAnswers->currentItem();

    if( !item ) return;

    QValueListIterator<AnswerCopy> it;
    for( it = _answerCopy.begin(); it != _answerCopy.end(); ++it )
    {
        if( (*it).text == item->text(0) ) { _answerCopy.remove( it ); break;	}
    }
    _listAnswers->removeItem( _listAnswers->currentItem() );
}

/** Button Up */
void KControlAddEdit::slot_ButtonUp()
{
    QListViewItem *item = _listAnswers->currentItem();

    if( !item ) return;
    if( _listAnswers->itemPos(item) < 1 ) return;

    QString textTMP = item->text(0);
    _listAnswers->clearSelection();

    QValueListIterator<AnswerCopy> it;
    for( it = _answerCopy.begin(); it != _answerCopy.end(); ++it )
    {
        if( (*it).text == textTMP )
        {
            bool resultTMP;
            int pointsTMP;
            QString textNEXT;
            bool resultNEXT;
            int pointsNEXT;

            resultTMP = (*it).result;
            pointsTMP = (*it).points;
            --it;
            textNEXT = (*it).text;
            resultNEXT = (*it).result;
            pointsNEXT = (*it).points;
            (*it).text = textTMP;
            (*it).result = resultTMP;
            (*it).points = pointsTMP;
            ++it;
            (*it).text = textNEXT;
            (*it).result = resultNEXT;
            (*it).points = pointsNEXT;
            break;
        }
    }
    refreshAnswer_list();
}

/** Button Down */
void KControlAddEdit::slot_ButtonDown()
{
    QListViewItem *item = _listAnswers->currentItem();

    if( !item ) return;
    if( item == _listAnswers->lastItem() ) return;

    QString textTMP = item->text(0);
    _listAnswers->clearSelection();

    QValueListIterator<AnswerCopy> it;
    for( it = _answerCopy.begin(); it != _answerCopy.end(); ++it )
    {
        if( (*it).text == textTMP )
        {
            bool resultTMP;
            int pointsTMP;
            QString textNEXT;
            bool resultNEXT;
            bool pointsNEXT;

            resultTMP = (*it).result;
            pointsTMP = (*it).points;
            ++it;
            textNEXT = (*it).text;
            resultNEXT = (*it).result;
            pointsNEXT = (*it).points;
            (*it).text = textTMP;
            (*it).result = resultTMP;
            (*it).points = pointsTMP;
            --it;
            (*it).text = textNEXT;
            (*it).result = resultNEXT;
            (*it).points = pointsNEXT;
            break;
        }
    }
    refreshAnswer_list();
}

/** Accept changes */
void KControlAddEdit::accept()
{
    if( !_editMode )
        _keducaFile->insertQuestion();

    addQuestion();
    configWrite();
    this->done( QDialog::Accepted );
}

/** Add question with form data */
void KControlAddEdit::addQuestion()
{
    _keducaFile->setQuestion( FileRead::QF_TEXT, _questionText->text() );
    _keducaFile->setQuestion( FileRead::QF_TYPE, _questionType->currentItem()+1 );
    _keducaFile->setQuestion( FileRead::QF_PICTURE, _questionPicture->url() );
    _keducaFile->setQuestion( FileRead::QF_POINTS, _questionPoint->value() );
    _keducaFile->setQuestion( FileRead::QF_TIME, _questionTime->value() );
    _keducaFile->setQuestion( FileRead::QF_TIP, _questionTip->text() );
    _keducaFile->setQuestion( FileRead::QF_EXPLAIN, _questionExplain->text() );

    _keducaFile->clearAnswers();
    QValueListIterator<AnswerCopy> it;
    int i=0;
    for( it = _answerCopy.begin(); it != _answerCopy.end(); ++it )
    {
        _keducaFile->setAnswer( (*it).text, (*it).result, (*it).points );
        i++;
    }
}
/** Read config settings */
void KControlAddEdit::configRead()
{
    KConfig *config = KGlobal::config();
    config->setGroup("AddModify Window");
    QSize defaultSize(500,400);
    this->resize( config->readSizeEntry("Geometry", &defaultSize ) );
}

/** Write config settings */
void KControlAddEdit::configWrite()
{
    KConfig *config = KGlobal::config();
    config->setGroup("AddModify Window");
    config->writeEntry("Geometry", this->size() );
    config->sync();
}

/** Set page question */
void KControlAddEdit::setPageQuestion()
{
    _pageQuestion = new QWidget(this);
    QHBoxLayout *_pageQuestionLayout = new QHBoxLayout( _pageQuestion );
    _pageQuestionLayout->setSpacing( 6 );
    _pageQuestionLayout->setMargin( 0 );

    QFrame *frame14 = new QFrame( _pageQuestion, "frame14" );
    frame14->setMinimumSize( QSize( 125, 0 ) );
    frame14->setMaximumSize( QSize( 125, 32767 ) );
    frame14->setFrameShape( QFrame::Box );
    frame14->setFrameShadow( QFrame::Plain );
    frame14->setBackgroundPixmap( QPixmap(locate("appdata","pics/bk_frame.png") ) );
    QVBoxLayout *frame14Layout = new QVBoxLayout( frame14 );
    frame14Layout->setSpacing( 6 );
    frame14Layout->setMargin( 11 );

    _questionPreview1 = new QLabel( frame14, "_questionPreview1" );
    _questionPreview1->setMinimumSize( QSize( 100, 100 ) );
    _questionPreview1->setMaximumSize( QSize( 100, 100 ) );
    _questionPreview1->setPalette( QPalette( QColor(255, 255, 255) ) );
    _questionPreview1->setFrameShape( QFrame::Box );
    _questionPreview1->setFrameShadow( QFrame::Plain );
    _questionPreview1->setScaledContents( TRUE );
    frame14Layout->addWidget( _questionPreview1 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    frame14Layout->addItem( spacer );

    QLabel *textLabel2 = new QLabel( frame14, "textLabel2" );
    textLabel2->setText( "<span style=\"color:black\">"+i18n( "<p><b>Question</b></p><hr><p>Only the question and type is required.</p>" )+"</span>" );
    textLabel2->setBackgroundPixmap( QPixmap(locate("appdata","pics/bk_frame.png") ) );
    frame14Layout->addWidget( textLabel2 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    frame14Layout->addItem( spacer_2 );
    _pageQuestionLayout->addWidget( frame14 );

    QFrame *frame15 = new QFrame( _pageQuestion, "frame15" );
    frame15->setFrameShape( QFrame::Box );
    frame15->setFrameShadow( QFrame::Sunken );
    QGridLayout *frame15Layout = new QGridLayout( frame15 );
    frame15Layout->setSpacing( 6 );
    frame15Layout->setMargin( 6 );

    QLabel *textLabel3 = new QLabel( frame15, "textLabel3" );
    textLabel3->setText( i18n( "Question:" ) );
    textLabel3->setAlignment( int( QLabel::AlignTop | QLabel::AlignRight ) );
    frame15Layout->addWidget( textLabel3, 0, 0 );

    QLabel *textLabel4 = new QLabel( frame15, "textLabel4" );
    textLabel4->setText( i18n( "Picture:" ) );
    textLabel4->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    frame15Layout->addWidget( textLabel4, 1, 0 );

    _questionText = new QMultiLineEdit( frame15, "_questionText" );
    _questionText->setWordWrap( QMultiLineEdit::WidgetWidth );
    connect( _questionText, SIGNAL( textChanged() ), this, SLOT( slotDataChanged() ) );
    frame15Layout->addWidget( _questionText, 0, 1 );

    _questionPicture = new KURLRequester( frame15, "_questionPicture" );
    connect( _questionPicture, SIGNAL( textChanged( const QString & ) ), this, SLOT( slotPreview( const QString & ) ) );
    frame15Layout->addWidget( _questionPicture, 1, 1 );

    QLabel *textLabel5 = new QLabel( frame15, "textLabel5" );
    textLabel5->setText( i18n( "Type:" ) );
    textLabel5->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    frame15Layout->addWidget( textLabel5, 2, 0 );

    QHBoxLayout *layout12 = new QHBoxLayout;
    layout12->setSpacing( 6 );
    layout12->setMargin( 0 );

    _questionType = new KComboBox( FALSE, frame15, "_questionType" );
    _questionType->insertItem( i18n("Test") );
    _questionType->insertItem( i18n("Test with Question Points") );
    _questionType->insertItem( i18n("Test with Answers Points") );
    connect( _questionType, SIGNAL( activated(int) ), this, SLOT( slotQuestionType(int) ) );
    layout12->addWidget( _questionType );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout12->addItem( spacer_3 );

    frame15Layout->addLayout( layout12, 2, 1 );

    QLabel *textLabel61 = new QLabel( frame15, "textLabel61" );
    textLabel61->setText( i18n( "Point:" ) );
    textLabel61->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    frame15Layout->addWidget( textLabel61, 3, 0 );

    QHBoxLayout *layout131 = new QHBoxLayout;
    layout131->setSpacing( 6 );
    layout131->setMargin( 0 );
    _questionPoint = new KIntNumInput( frame15, "_questionPoint" );
    layout131->addWidget( _questionPoint );
    QSpacerItem* spacer_41 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout131->addItem( spacer_41 );
    frame15Layout->addLayout( layout131, 3, 1 );

    QLabel *textLabel6 = new QLabel( frame15, "textLabel6" );
    textLabel6->setText( i18n( "Time:" ) );
    textLabel6->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    frame15Layout->addWidget( textLabel6, 4, 0 );

    QHBoxLayout *layout13 = new QHBoxLayout;
    layout13->setSpacing( 6 );
    layout13->setMargin( 0 );
    _questionTime = new KIntNumInput( frame15, "_questionTime" );
    layout13->addWidget( _questionTime );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout13->addItem( spacer_4 );
    frame15Layout->addLayout( layout13, 4, 1 );

    QLabel *textLabel7 = new QLabel( frame15, "textLabel7" );
    textLabel7->setText( i18n( "Tip:" ) );
    textLabel7->setAlignment( int( QLabel::AlignTop | QLabel::AlignRight ) );
    frame15Layout->addWidget( textLabel7, 5, 0 );
    _questionTip = new QLineEdit( frame15, "_questionTip" );
    frame15Layout->addWidget( _questionTip, 5, 1 );

    QLabel *textLabel8 = new QLabel( frame15, "textLabel8" );
    textLabel8->setText( i18n( "Explain:" ) );
    textLabel8->setAlignment( int( QLabel::AlignTop | QLabel::AlignRight ) );
    frame15Layout->addWidget( textLabel8, 6, 0 );

    _questionExplain = new QMultiLineEdit( frame15, "_questionExplain" );
    _questionExplain->setWordWrap( QMultiLineEdit::WidgetWidth );
    frame15Layout->addWidget( _questionExplain, 6, 1 );

    _pageQuestionLayout->addWidget( frame15 );
    this->addPage( _pageQuestion, i18n( "Question" ) );
    this->setHelpEnabled ( _pageQuestion, false );
    this->setNextEnabled( _pageQuestion, false );
}

/** Set answer page */
void KControlAddEdit::setPageAnswer()
{
    KIconLoader *iconloader = KGlobal::iconLoader();

    _pageAnswer = new QWidget( this, "_pageAnswer" );
    QHBoxLayout *_pageAnswerLayout = new QHBoxLayout( _pageAnswer );
    _pageAnswerLayout->setSpacing( 6 );
    _pageAnswerLayout->setMargin( 0 );

    QFrame *frame14_2 = new QFrame( _pageAnswer, "frame14_2" );
    frame14_2->setMinimumSize( QSize( 125, 0 ) );
    frame14_2->setMaximumSize( QSize( 125, 32767 ) );
    frame14_2->setFrameShape( QFrame::Box );
    frame14_2->setFrameShadow( QFrame::Plain );
    frame14_2->setBackgroundPixmap( QPixmap(locate("appdata","pics/bk_frame.png") ) );
    QVBoxLayout *frame14_2Layout = new QVBoxLayout( frame14_2 );
    frame14_2Layout->setSpacing( 6 );
    frame14_2Layout->setMargin( 11 );

    _questionPreview2 = new QLabel( frame14_2, "_questionPreview2" );
    _questionPreview2->setMinimumSize( QSize( 100, 100 ) );
    _questionPreview2->setMaximumSize( QSize( 100, 100 ) );
    _questionPreview2->setPalette( QPalette( QColor(255, 255, 255) ) );
    _questionPreview2->setFrameShape( QFrame::Box );
    _questionPreview2->setFrameShadow( QFrame::Plain );
    _questionPreview2->setScaledContents( TRUE );
    frame14_2Layout->addWidget( _questionPreview2 );
    QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    frame14_2Layout->addItem( spacer_5 );

    QLabel *textLabel2_2 = new QLabel( frame14_2, "textLabel2_2" );
    textLabel2_2->setText( "<span style=\"color:black\">"+i18n( "<p><b>Answers</b></p><hr><p>Only the Answer and Value is required.</p>" )+"</span>" );
    textLabel2_2->setBackgroundPixmap( QPixmap(locate("appdata","pics/bk_frame.png") ) );
    frame14_2Layout->addWidget( textLabel2_2 );
    QSpacerItem* spacer_6 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    frame14_2Layout->addItem( spacer_6 );
    _pageAnswerLayout->addWidget( frame14_2 );

    QFrame *frame17 = new QFrame( _pageAnswer, "frame17" );
    frame17->setFrameShape( QFrame::Box );
    frame17->setFrameShadow( QFrame::Sunken );
    QVBoxLayout *frame17Layout = new QVBoxLayout( frame17 );
    frame17Layout->setSpacing( 6 );
    frame17Layout->setMargin( 6 );

    QHBoxLayout *layout16 = new QHBoxLayout;
    layout16->setSpacing( 4 );
    layout16->setMargin( 0 );

    _listAnswers = new KListView( frame17, "_listAnswers" );
    _listAnswers->addColumn( i18n( "Answer" ) );
    _listAnswers->addColumn( i18n( "Value" ) );
    _listAnswers->addColumn( i18n( "Points" ) );
    _listAnswers->setAllColumnsShowFocus ( true ),
        _listAnswers->setSorting(-1);
    _listAnswers->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)5, _listAnswers->sizePolicy().hasHeightForWidth() ) );
    layout16->addWidget( _listAnswers );

    QVBoxLayout *layout15 = new QVBoxLayout;
    layout15->setSpacing( 6 );
    layout15->setMargin( 0 );

    _buttonRemove = new QPushButton( frame17, "_buttonRemove" );
    _buttonRemove->setText( i18n( "&Remove" ) );
    connect( _buttonRemove, SIGNAL(clicked()), this, SLOT(slot_ButtonRemove()) );
    layout15->addWidget( _buttonRemove );
    QSpacerItem* spacer_7 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout15->addItem( spacer_7 );

    QGridLayout *layout14 = new QGridLayout;
    layout14->setSpacing( 6 );
    layout14->setMargin( 0 );
    QSpacerItem* spacer_8 = new QSpacerItem( 20, 20, QSizePolicy::Preferred, QSizePolicy::Minimum );
    layout14->addItem( spacer_8, 0, 1 );
    QSpacerItem* spacer_9 = new QSpacerItem( 20, 20, QSizePolicy::Preferred, QSizePolicy::Minimum );
    layout14->addItem( spacer_9, 1, 1 );

    _buttonDown = new QPushButton( frame17, "_buttonDown" );
    _buttonDown->setPixmap( iconloader->loadIcon( "down.png",
                                                  KIcon::Small ) );
    connect( _buttonDown, SIGNAL( clicked() ), this, SLOT( slot_ButtonDown() ) );

    layout14->addWidget( _buttonDown, 1, 0 );

    _buttonUp = new QPushButton( frame17, "_buttonUp" );
    _buttonUp->setPixmap( iconloader->loadIcon( "up.png",
                                                KIcon::Small )  );
    connect( _buttonUp, SIGNAL( clicked() ), this, SLOT( slot_ButtonUp() ) );

    layout14->addWidget( _buttonUp, 0, 0 );
    layout15->addLayout( layout14 );
    layout16->addLayout( layout15 );
    frame17Layout->addLayout( layout16 );

    QFrame *line3 = new QFrame( frame17, "line3" );
    line3->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    frame17Layout->addWidget( line3 );

    QGridLayout *layout20 = new QGridLayout;
    layout20->setSpacing( 4 );
    layout20->setMargin( 0 );
    QSpacerItem* spacer_10 = new QSpacerItem( 20, 20, QSizePolicy::Preferred, QSizePolicy::Minimum );
    layout20->addItem( spacer_10, 3, 0 );

    QLabel *textLabel11 = new QLabel( frame17, "textLabel11" );
    textLabel11->setText( i18n( "Points:" ) );
    textLabel11->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    layout20->addWidget( textLabel11, 2, 0 );

    _buttonInsert = new QPushButton( frame17, "_buttonInsert" );
    connect( _buttonInsert, SIGNAL(clicked()), this, SLOT(slot_ButtonAdd()) );
    _buttonInsert->setText( i18n( "Insert" ) );

    layout20->addWidget( _buttonInsert, 3, 1 );

    _answerText = new QMultiLineEdit( frame17, "_answerText" );
    _answerText->setWordWrap( QMultiLineEdit::WidgetWidth );
    layout20->addWidget( _answerText, 0, 1 );

    QHBoxLayout *layout19 = new QHBoxLayout;
    layout19->setSpacing( 6 );
    layout19->setMargin( 0 );

    _answerPoints = new KIntNumInput( frame17, "_answerPoints" );
    layout19->addWidget( _answerPoints );
    QSpacerItem* spacer_11 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout19->addItem( spacer_11 );

    layout20->addLayout( layout19, 2, 1 );

    QHBoxLayout *layout17 = new QHBoxLayout;
    layout17->setSpacing( 6 );
    layout17->setMargin( 0 );

    _answerValue = new KComboBox( FALSE, frame17, "_answerValue" );
    _answerValue->insertItem( i18n( "False" ) );
    _answerValue->insertItem( i18n( "True" ) );
    layout17->addWidget( _answerValue );
    QSpacerItem* spacer_12 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout17->addItem( spacer_12 );

    layout20->addLayout( layout17, 1, 1 );

    QLabel *textLabel10 = new QLabel( frame17, "textLabel10" );
    textLabel10->setText( i18n( "Value:" ) );
    textLabel10->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    layout20->addWidget( textLabel10, 1, 0 );

    QLabel *textLabel9 = new QLabel( frame17, "textLabel9" );
    textLabel9->setText( i18n( "Answer:" ) );
    textLabel9->setAlignment( int( QLabel::AlignTop | QLabel::AlignRight ) );

    layout20->addWidget( textLabel9, 0, 0 );
    frame17Layout->addLayout( layout20 );
    _pageAnswerLayout->addWidget( frame17 );
    this->addPage( _pageAnswer, i18n( "Answers" ) );
    this->setHelpEnabled ( _pageAnswer, false );
    this->setFinishEnabled( _pageAnswer, true );
}

/** Question data changed */
void KControlAddEdit::slotDataChanged()
{
    if( _pageQuestion == this->currentPage() )
    {
        if( _questionText->text().isEmpty() )
        {
            nextButton()->setEnabled( false );
        }
        else
        {
            nextButton()->setEnabled( true );
        }
    }
}

/** Preview image */
void KControlAddEdit::slotPreview( const QString &text)
{
    if( text.isEmpty() ) { _questionPreview1->setText(""); _questionPreview2->setText(""); return; }

    _questionPreview1->setPixmap( QPixmap( text ) );
    _questionPreview2->setPixmap( QPixmap( text ) );
}

/** show current Page */
void KControlAddEdit::showPage(QWidget *page)
{
    QWizard::showPage(page);

    if ( page == _pageQuestion ) {
        slotDataChanged();
        _questionText->setFocus();
    } else if ( page == _pageAnswer ) {
        _answerText->setFocus();
    }
}

/** Change question type */
void KControlAddEdit::slotQuestionType( int index )
{
    switch( index+1 )
    {
    case 1:
        _questionPoint->setEnabled( false );
        _answerPoints->setEnabled( false );
        _questionPoint->setValue(0);
        _answerPoints->setValue(0);
        break;
    case 2:
        _questionPoint->setEnabled( true );
        _answerPoints->setEnabled( false );
        _answerPoints->setValue(0);
        break;
    case 3:
        _questionPoint->setEnabled( false );
        _answerPoints->setEnabled( true );
        _questionPoint->setValue(0);
        break;
    default:
        break;
    }
}
