/***************************************************************************
                            QCanvasView.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QCANVASVIEW_H
#define QCANVASVIEW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QScrollView.h>

@class QCanvas;

@class QContextMenuEvent; 
@class QIMEvent; 
@class QTabletEvent; 
@class QWMatrix; 

@interface QCanvasView : QScrollView 
- initWithWidget: (QWidget *)parent name: (NSString *)name f: (int)f;
- init;
- initWithCanvas: (QCanvas*)viewing parent: (QWidget *)parent name: (NSString *)name f: (int)f;
- initWithCanvas: (QCanvas*)viewing ;
- (void) dealloc;
- (QCanvas*) canvas;
- setCanvas: (QCanvas*)v;
- (QWMatrix*) worldMatrix;
- (QWMatrix*) inverseWorldMatrix;
- (BOOL) setWorldMatrix: (QWMatrix *)arg1;
- drawContents: (QPainter *)arg1 cx: (int)cx cy: (int)cy cw: (int)cw ch: (int)ch;
- (QSize*) sizeHint;
@end

/** Override these methods in subclasses of QCanvasView to customise event handling behaviour */
@protocol QCanvasViewEventHandling
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- keyPressEvent:(QKeyEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) arg1;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) arg1;
- contentsMouseMoveEvent:(QMouseEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- contentsMousePressEvent:(QMouseEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
