/***************************************************************************
* $Id: Forever.java,v 1.2 2002/03/10 16:08:03 rdale Exp $
**
* Definition of something or other
**
* Created : 979899
**
* Copyright (C) 1997 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.kde.qt.*;
import java.util.Random;



class Forever  extends QWidget
{
static final int numColors = 120;

private    int		rectangles;
private    QColor[]	colors = new QColor[numColors];
private    Random generator = new Random(System.currentTimeMillis());



//
// Forever - a widget that draws rectangles forever.
//

//
// Constructs a Forever widget.
//
Forever( )
{
	this(null, null);
}

Forever( QWidget parent, String name )
{
    super( parent, name );
    for (int a=0; a<numColors; a++) {
	colors[a] = new QColor( generator.nextInt(255),
			    generator.nextInt(255),
			    generator.nextInt(255) );
    }
    rectangles = 0;
    startTimer( 0 );				// run continuous timer
    QTimer  counter = new QTimer( this );
    connect( counter, SIGNAL("timeout()"),
	     this, SLOT("updateCaption()") );
    counter.start( 1000 );
}


void updateCaption()
{
    String s = "Qt Example - Forever - " + rectangles + " rectangles/second";
    rectangles = 0;
    setCaption( s );
}


//
// Handles paint events for the Forever widget.
//

void paintEvent( QPaintEvent e  )
{
    QPainter paint = new QPainter( this );			// painter object
    int w = width();
    int h = height();
    if(w <= 0 || h <= 0) 
	return;
    paint.setPen( NoPen );			// do not draw outline
    paint.setBrush( colors[generator.nextInt(numColors)]);// set random brush color
    
    QPoint p1 = new QPoint( generator.nextInt(w), generator.nextInt(h));	// p1 = top left
    QPoint p2 = new QPoint( generator.nextInt(w), generator.nextInt(h));	// p2 = bottom right
    
    QRect r = new QRect( p1, p2 );
    paint.drawRect( r );			// draw filled rectangle
}

//
// Handles timer events for the Forever widget.
//

void timerEvent( QTimerEvent e )
{
    for ( int i=0; i<100; i++ ) {
	repaint( false );			// repaint, don't erase
	rectangles++;
    }
}


//
// Create and display Forever widget.
//

public static void main( String[] args )
{
    QApplication a = new QApplication( args );		// create application object
    Forever always = new Forever();				// create widget
    a.setMainWidget( always );			// set as main widget
    always.setCaption("Qt Example - Forever");
    always.show();				// show widget
    a.exec();				// run event loop
	return;
}

static {
	qtjava.initialize();
}
}
