/***************************************************************************
                            KPushButton.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is nothing but a QPushButton with drag-support and KGuiItem support. You have to call
 {@link #setDragEnabled} and override the virtual method
 {@link #dragObject} to specify the QDragObject to be used.

 See {@link KPushButtonSignals} for signals emitted by KPushButton.

 

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A QPushButton with drag-support and KGuiItem support.
*/
public class KPushButton extends QPushButton  {
	protected KPushButton(Class dummy){super((Class) null);}

	private native void newKPushButton( QWidget parent, String name);

/** 
 Default constructor.
     
*/
	public KPushButton( QWidget parent, String name) {
		super((Class) null);
		newKPushButton( parent, name);
	}
	private native void newKPushButton( QWidget parent);
	public KPushButton( QWidget parent) {
		super((Class) null);
		newKPushButton( parent);
	}
	private native void newKPushButton( String text, QWidget parent, String name);

/** 
 Constructor, that sets the button-text to <code>text</code>
     
*/
	public KPushButton( String text, QWidget parent, String name) {
		super((Class) null);
		newKPushButton( text, parent, name);
	}
	private native void newKPushButton( String text, QWidget parent);
	public KPushButton( String text, QWidget parent) {
		super((Class) null);
		newKPushButton( text, parent);
	}
	private native void newKPushButton( QIconSet icon, String text, QWidget parent, String name);

/** 
 Constructor, that sets an icon and the button-text to <code>text</code>
     
*/
	public KPushButton( QIconSet icon, String text, QWidget parent, String name) {
		super((Class) null);
		newKPushButton( icon, text, parent, name);
	}
	private native void newKPushButton( QIconSet icon, String text, QWidget parent);
	public KPushButton( QIconSet icon, String text, QWidget parent) {
		super((Class) null);
		newKPushButton( icon, text, parent);
	}
	private native void newKPushButton( KGuiItem item, QWidget parent, String name);

/** 
 Constructor that takes a KGuiItem for the text, the icon, the tooltip
 and the what's this help
     
*/
	public KPushButton( KGuiItem item, QWidget parent, String name) {
		super((Class) null);
		newKPushButton( item, parent, name);
	}
	private native void newKPushButton( KGuiItem item, QWidget parent);
	public KPushButton( KGuiItem item, QWidget parent) {
		super((Class) null);
		newKPushButton( item, parent);
	}

/** 
 Destructs the button.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Enables/disables drag-support. Default is enabled.
     
*/
	public native void setDragEnabled( boolean enable);

/** 

*/
	public native boolean isDragEnabled();

/** 
 Sets the KGuiItem for this button.
     
*/
	public native void setGuiItem( KGuiItem item);

/** 
 Reimplement this and return the QDragObject that should be used
 for the drag.
 Default implementation returns null, so that no drag is initiated.
     
*/
	protected native QDragObject dragObject();

/** 
 Reimplemented to add drag-support
     
*/
	protected native void mousePressEvent( QMouseEvent arg1);

/** 
 Reimplemented to add drag-support
     
*/
	protected native void mouseMoveEvent( QMouseEvent arg1);

/** 
 Starts a drag (dragCopy() by default) using {@link #dragObject}
     
*/
	protected native void startDrag();
	protected native void virtual_hook( int identifier, int data);
}
