/***************************************************************************
                            KCharsets.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Charset font and encoder/decoder handling.

 This is needed, because Qt's font matching algorithm gives the font
 family a higher priority than the charset.  For many applications
 this is not acceptable, since it can totally obscure the output,
 in languages which use non iso-8859-1 charsets.

 @author Lars Knoll <knoll@kde.org>

 @version $Id: KCharsets.java,v 1.7 2002/11/26 04:17:31 rdale Exp $
 
 @short *
 Charset font and encoder/decoder handling.
*/
public class  KCharsets implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KCharsets(Class dummy){}


/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Provided for compatibility.

*/
	public native QTextCodec codecForName( String name);

/** 
 Tries to find a QTextCodec to convert the given encoding from and to
 Unicode. If no codec could be found the latin1 codec will be returned an
 <code>ok</code> will be set to false.

*/
	public native QTextCodec codecForName( String n, boolean ok);

/** 
 Lists all available encodings as names.

*/
	public native ArrayList availableEncodingNames();

/** 
 Lists the available encoding names together with a more descriptive language.

*/
	public native ArrayList descriptiveEncodingNames();

/** 
 Lists all languages.

*/
	public native ArrayList languages();

/** 
 Lists all available encodings for language name 'language'.

*/
	public native ArrayList encodingsForLanguage( String language);

/** 
 Returns the language the encoding is used for. 

*/
	public native String languageForEncoding( String encoding);

/** 
 Returns the encoding for a string obtained with descriptiveEncodingNames().

*/
	public native String encodingForName( String descriptiveName);

/** 
 Converts an entity to a character. The string must contain only the
 entity without the trailing ';'.

*/
	public static native char fromEntity( String str);

/** 
 Overloaded member function. Tries to find an entity in the
 {@link String} str.

*/
	public static native char fromEntity( String str, int len);

/** 
 Converts a QChar to an entity. The returned string does already
 contain the leading '&' and the trailing ';'.

*/
	public static native String toEntity( char ch);

/** 
 Scans the given string for entities (like &amp;amp;) and resolves them
 using fromEntity.

*/
	public static native String resolveEntities( String text);
	private native void newKCharsets();

/**  Protected constructor. If you need the kcharsets object, use
        {@link KGlobal#charsets} instead.
    
*/
	public KCharsets() {
		newKCharsets();
	}
}
