/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __hwdata_h__
#define __hwdata_h__

#include <qvaluelist.h>
#include <qmap.h>
#include <qstringlist.h>
#include <qstring.h>
#include <qdom.h>

typedef QStringList HWDataEntry;
typedef QValueList<HWDataEntry> HWDataEntryList;

class HWData
{
public:
    HWData();
    ~HWData();

    bool open( const QString &filename );

    bool append( const QDomElement &dataset );

    QStringList keys() const;
    uint indexOfKey( const QString &key );

    HWDataEntryList data() const;

    uint count() const;
    HWDataEntry operator[]( uint index ) const;

private:
    HWDataEntryList m_data;
    QStringList m_keys;
};

inline QStringList HWData::keys() const
{
    return m_keys;
}

inline uint HWData::indexOfKey( const QString &key )
{
    return m_keys.findIndex( key );
}

inline HWDataEntryList HWData::data() const
{
    return m_data;
}

inline uint HWData::count() const
{
    return m_data.count();
}

inline HWDataEntry HWData::operator[]( uint index ) const
{
    return m_data[ index ];
}

#endif
