/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2002 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * preferences.c - load and save program settings
 */


#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "preferences.h"
#include "types.h"
#include "utils.h"

preferencestype preferences;
extern gchar *xlogdir;


void loadpreferences(void) {
	gchar *preferencesfile, label[100], value[100];
	FILE *fp;
	GString *sdir = g_string_new("");;

	/* defaults */
	preferences.version = g_strdup("0.0");
	preferences.x = 10;
	preferences.y = 30;
	preferences.width = 750;
	preferences.height = 540;
	preferences.latitude = 0.0;
	preferences.NS = 1;
	preferences.longitude = 0.0;
	preferences.EW = 1;
	preferences.units = 1;
	preferences.bands = g_strdup("1.8,3.5,7,10,14,18,21,24,28");
	preferences.modes = g_strdup("CW,SSB,PSK31,MFSK,MT63,SSTV");
	preferences.bandseditbox = 0;
	preferences.modeseditbox = 0;
	preferences.printall = 0;
	preferences.printsize = 0;
	preferences.printpoint = 0;
	preferences.printstyle = 0;
	preferences.printdestination = 0;
	preferences.columnsizes = g_strdup(",");
	preferences.hamlib = 0;
	preferences.radio = g_strdup("Dummy");
	preferences.device = g_strdup("/dev/ttyS1");
	preferences.round = 0;
	preferences.clock = 0;
	preferences.themecolor = g_strdup("0000,0000,cd00");
	preferences.logcolor = 1;
	preferences.autosave = 0;
	g_string_sprintf(sdir, "%s.", G_DIR_SEPARATOR_S);
	g_string_append(sdir, PACKAGE);
	preferences.savedir = g_strconcat(g_get_home_dir(), sdir->str, NULL);
	preferences.logstoload = g_strdup("*");
	g_string_free(sdir, TRUE);

	/* open preferences file */
	preferencesfile = g_strconcat(xlogdir, G_DIR_SEPARATOR_S, "preferences", NULL);
	fp = fopen(preferencesfile, "r");

	if (fp != NULL) {
	/* read preferences file */
		while(!feof(fp)) {
			if (fscanf(fp, "%s %s", label, value) == EOF) break;
			if (!g_strcasecmp(label, "version"))
				preferences.version = g_strdup(value);
			else if (!g_strcasecmp(label, "x"))
				preferences.x = atoi(value);
			else if (!g_strcasecmp(label, "y"))
				preferences.y = atoi(value);
			else if (!g_strcasecmp(label, "width"))
				preferences.width = atoi(value);
			else if (!g_strcasecmp(label, "height"))
				preferences.height = atoi(value);
			else if (!g_strcasecmp(label, "latitude"))
				preferences.latitude = atof(value);
			else if (!g_strcasecmp(label, "NS"))
				preferences.NS = atoi(value);
			else if (!g_strcasecmp(label, "longitude"))
				preferences.longitude = atof(value);
			else if (!g_strcasecmp(label, "EW"))
				preferences.EW = atoi(value);
			else if (!g_strcasecmp(label, "units"))
				preferences.units = atoi(value);
			else if (!g_strcasecmp(label, "bands"))
				preferences.bands = g_strdup(value);
			else if (!g_strcasecmp(label, "modes"))
				preferences.modes = g_strdup(value);
			else if (!g_strcasecmp(label, "modeseditbox"))
				preferences.modeseditbox = atoi(value);
			else if (!g_strcasecmp(label, "bandseditbox"))
				preferences.bandseditbox = atoi(value);
			else if (!g_strcasecmp(label, "printall"))
				preferences.printall = atoi(value);
			else if (!g_strcasecmp(label, "printsize"))
				preferences.printsize = atoi(value);
			else if (!g_strcasecmp(label, "printpoint"))
				preferences.printpoint = atoi(value);
			else if (!g_strcasecmp(label, "printdestination"))
				preferences.printdestination = atoi(value);
			else if (!g_strcasecmp(label, "printstyle"))
				preferences.printstyle = atoi(value);
			else if (!g_strcasecmp(label, "columnsizes"))
				preferences.columnsizes = g_strdup(value);
			else if (!g_strcasecmp(label, "hamlib"))
				preferences.hamlib = atoi(value);
			else if (!g_strcasecmp(label, "radio"))
				preferences.radio = g_strdup(value);
			else if (!g_strcasecmp(label, "device")) {
				preferences.device = g_strdup(value);
				g_strdelimit(preferences.radio, "_", ' ');
			}
			else if (!g_strcasecmp(label, "round"))
				preferences.round = atoi(value);
			else if (!g_strcasecmp(label, "clock"))
				preferences.clock = atoi(value);
			else if (!g_strcasecmp(label, "themecolor"))
				preferences.themecolor = g_strdup(value);
			else if (!g_strcasecmp(label, "logcolor"))
				preferences.logcolor = atoi(value);
			else if (!g_strcasecmp(label, "autosave"))
				preferences.autosave = atoi(value);
			else if (!g_strcasecmp(label, "savedir"))
				preferences.savedir = g_strdup(value);
			else if (!g_strcasecmp(label, "logstoload"))
				preferences.logstoload = g_strdup(value);
		}
		fclose(fp);
	}
	g_free(preferencesfile);
}

void savepreferences(void) {
	gchar *preferencesfile, *temp;
	FILE *fp;

	/* open preferences file */
	preferencesfile = g_strconcat(xlogdir, G_DIR_SEPARATOR_S, "preferences", NULL);
	fp = fopen(preferencesfile, "w");
	if (fp != NULL) {
		/* warning and version */
		fprintf(fp, "# settings file for %s, do not edit\n", PACKAGE);
		fprintf(fp, "version %s\n", VERSION);
		temp = g_strdup_printf("%d", preferences.x);
		fprintf(fp, "x %s\n", temp);
		temp = g_strdup_printf("%d", preferences.y);
		fprintf(fp, "y %s\n", temp);
		temp = g_strdup_printf("%d", preferences.width);
		fprintf(fp, "width %s\n", temp);
		temp = g_strdup_printf("%d", preferences.height);
		fprintf(fp, "height %s\n", temp);
		temp = g_strdup_printf("%3.2f", preferences.latitude);
		fprintf(fp, "latitude %s\n", temp);
		temp = g_strdup_printf("%d", preferences.NS);
		fprintf(fp, "NS %s\n", temp);
		temp = g_strdup_printf("%3.2f", preferences.longitude);
		fprintf(fp, "longitude %s\n", temp);
		temp = g_strdup_printf("%d", preferences.EW);
		fprintf(fp, "EW %s\n", temp);
		temp = g_strdup_printf("%d", preferences.units);
		fprintf(fp, "units %s\n", temp);
		temp = g_strdup(preferences.bands);
		fprintf(fp, "bands %s\n", temp);
		temp = g_strdup(preferences.modes);
		fprintf(fp, "modes %s\n", temp);
		temp = g_strdup_printf("%d", preferences.modeseditbox);
		fprintf(fp, "modeseditbox %s\n", temp);
		temp = g_strdup_printf("%d", preferences.bandseditbox);
		fprintf(fp, "bandseditbox %s\n", temp);
		temp = g_strdup_printf("%d", preferences.printall);
		fprintf(fp, "printall %s\n", temp);
		temp = g_strdup_printf("%d", preferences.printsize);
		fprintf(fp, "printsize %s\n", temp);
		temp = g_strdup_printf("%d", preferences.printpoint);
		fprintf(fp, "printpoint %s\n", temp);
		temp = g_strdup_printf("%d", preferences.printstyle);
		fprintf(fp, "printstyle %s\n", temp);
		temp = g_strdup_printf("%d", preferences.printdestination);
		fprintf(fp, "printdestination %s\n", temp);
		temp = g_strdup(preferences.columnsizes);
		fprintf(fp, "columnsizes %s\n", temp);
		temp = g_strdup_printf("%d", preferences.hamlib);
		fprintf(fp, "hamlib %s\n", temp);
		temp = g_strdup(preferences.radio);
		g_strdelimit(preferences.radio, " ", '_'); /* can't save spaces */
		fprintf(fp, "radio %s\n", temp);
		temp = g_strdup(preferences.device);
		fprintf(fp, "device %s\n", temp);
		temp = g_strdup_printf("%d", preferences.round);
		fprintf(fp, "round %s\n", temp);
		temp = g_strdup_printf("%d", preferences.clock);
		fprintf(fp, "clock %s\n", temp);
		temp = g_strdup(preferences.themecolor);
		fprintf(fp, "themecolor %s\n", temp);
		temp = g_strdup_printf("%d", preferences.logcolor);
		fprintf(fp, "logcolor %s\n", temp);
		temp = g_strdup_printf("%d", preferences.autosave);
		fprintf(fp, "autosave %s\n", temp);
		temp = g_strdup(preferences.savedir);
		fprintf(fp, "savedir %s\n", temp);
		temp = g_strdup(preferences.logstoload);
		fprintf(fp, "logstoload %s\n", temp);
		g_free(temp);
		fclose(fp);
	}
	g_free(preferencesfile);
}
