/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.Trace;

class CertificateInfo {
    X509Certificate cert;

    CertificateInfo(X509Certificate x509Certificate) {
        this.cert = x509Certificate;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    private String extractAliasName(X509Certificate x509Certificate) {
        Object[] objectArray;
        Object object;
        String string = CertificateInfo.getMessage("security_dialog.unknown.subject");
        String string2 = CertificateInfo.getMessage("security_dialog.unknown.issuer");
        try {
            object = x509Certificate.getSubjectDN();
            objectArray = x509Certificate.getIssuerDN();
            String string3 = object.getName();
            String string4 = objectArray.getName();
            string = this.extractFromQuote(string3, "CN=");
            if (string == null) {
                string = this.extractFromQuote(string3, "O=");
            }
            if (string == null) {
                string = CertificateInfo.getMessage("security_dialog.unknown.subject");
            }
            if ((string2 = this.extractFromQuote(string4, "CN=")) == null) {
                string2 = this.extractFromQuote(string4, "O=");
            }
            if (string2 == null) {
                string2 = CertificateInfo.getMessage("security_dialog.unknown.issuer");
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        object = new MessageFormat(CertificateInfo.getMessage("security_dialog.certShowName"));
        objectArray = new Object[]{string, string2};
        return ((Format)object).format(objectArray);
    }

    private String extractFromQuote(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        int n2 = 0;
        if (n >= 0) {
            if ((n2 = string.charAt(n += string2.length()) == '\"' ? string.indexOf(34, ++n) : string.indexOf(44, n)) < 0) {
                return string.substring(n);
            }
            return string.substring(n, n2);
        }
        return null;
    }

    private static String getMessage(String string) {
        return ResourceHandler.getMessage(string);
    }

    public String toString() {
        return this.extractAliasName(this.cert);
    }
}

