/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;

abstract class SelectorImpl
extends AbstractSelector {
    protected Set selectedKeys;
    protected HashSet keys;
    private Lock lock = new Lock();
    private SelectGate selectGate = new SelectGate();

    protected SelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        this.selectedKeys = new HashSet();
        this.keys = new HashSet();
    }

    public Set keys() {
        return this.keys;
    }

    public Set selectedKeys() {
        return this.selectedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int select(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        SelectGate selectGate = this.selectGate;
        synchronized (selectGate) {
        }
        Lock lock = this.lock;
        synchronized (lock) {
            l2 = l2 == 0L ? -1L : l2;
            return this.doSelect(l2);
        }
    }

    public int select() throws IOException {
        return this.select(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectNow() throws IOException {
        SelectGate selectGate = this.selectGate;
        synchronized (selectGate) {
        }
        Lock lock = this.lock;
        synchronized (lock) {
            return this.doSelect(0L);
        }
    }

    protected abstract int doSelect(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void implCloseSelector() throws IOException {
        SelectGate selectGate = this.selectGate;
        synchronized (selectGate) {
            this.wakeup();
            Lock lock = this.lock;
            synchronized (lock) {
                this.implClose();
            }
        }
    }

    protected abstract void implClose() throws IOException;

    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n2) {
    }

    protected void finalize() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SelectionKey register(AbstractSelectableChannel abstractSelectableChannel, int n2, Object object) {
        if (!(abstractSelectableChannel instanceof SelChImpl)) {
            throw new IllegalSelectorException();
        }
        SelectionKeyImpl selectionKeyImpl = new SelectionKeyImpl((SelChImpl)((Object)abstractSelectableChannel), this);
        selectionKeyImpl.attach(object);
        Lock lock = this.lock;
        synchronized (lock) {
            this.implRegister(selectionKeyImpl);
        }
        selectionKeyImpl.interestOps(n2);
        return selectionKeyImpl;
    }

    protected abstract void implRegister(SelectionKeyImpl var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDeregisterQueue() throws IOException {
        Set set;
        Set set2 = set = this.cancelledKeys();
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.implDereg((SelectionKeyImpl)iterator.next());
                iterator.remove();
            }
        }
    }

    protected abstract void implDereg(SelectionKeyImpl var1) throws IOException;

    public abstract Selector wakeup();

    private static class SelectGate {
        private SelectGate() {
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

