/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.im.spi.InputMethodDescriptor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import sun.awt.InputMethodSupport;
import sun.awt.im.InputContext;
import sun.awt.im.InputMethodLocator;
import sun.awt.im.InputMethodManager;
import sun.misc.Service;

class ExecutableInputMethodManager
extends InputMethodManager
implements Runnable,
ActionListener {
    private InputContext currentInputContext;
    private String triggerMenuString;
    private PopupMenu selectionMenu;
    private static String selectInputMethodMenuTitle;
    private InputMethodLocator hostAdapterLocator;
    private int javaInputMethodCount;
    private Vector javaInputMethodLocatorList;
    private Component requestComponent;
    private InputContext requestInputContext;
    private static final String preferredIMNode = "/sun/awt/im/preferredInputMethod";
    private static final String descriptorKey = "descriptor";
    private Hashtable preferredLocatorCache = new Hashtable();
    private Preferences userRoot;
    static /* synthetic */ Class class$java$awt$im$spi$InputMethodDescriptor;

    ExecutableInputMethodManager() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            InputMethodDescriptor inputMethodDescriptor;
            if (toolkit instanceof InputMethodSupport && (inputMethodDescriptor = ((InputMethodSupport)((Object)toolkit)).getInputMethodAdapterDescriptor()) != null) {
                this.hostAdapterLocator = new InputMethodLocator(inputMethodDescriptor, null, null);
            }
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this.javaInputMethodLocatorList = new Vector();
        this.initializeInputMethodLocatorList();
        this.userRoot = this.getUserRoot();
    }

    synchronized void initialize() {
        this.triggerMenuString = selectInputMethodMenuTitle = Toolkit.getProperty("AWT.InputMethodSelectionMenu", "Select Input Method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.hasMultipleInputMethods()) {
            try {
                ExecutableInputMethodManager executableInputMethodManager = this;
                synchronized (executableInputMethodManager) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.selectionMenu = new PopupMenu(selectInputMethodMenuTitle);
        while (true) {
            this.waitForChangeRequest();
            this.initializeInputMethodLocatorList();
            this.showInputMethodMenu();
        }
    }

    void setInputContext(InputContext inputContext) {
        if (this.currentInputContext == null || inputContext != null) {
            // empty if block
        }
        this.currentInputContext = inputContext;
    }

    public synchronized void notifyChangeRequest(Component component) {
        if (!(component instanceof Frame) && !(component instanceof Dialog)) {
            return;
        }
        if (this.requestComponent != null) {
            return;
        }
        this.requestComponent = component;
        this.notify();
    }

    public synchronized void notifyChangeRequestByHotKey(Component component) {
        while (!(component instanceof Frame) && !(component instanceof Dialog)) {
            if (component == null) {
                return;
            }
            component = component.getParent();
        }
        this.notifyChangeRequest(component);
    }

    public String getTriggerMenuString() {
        return this.triggerMenuString;
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.changeInputMethod(string);
    }

    boolean hasMultipleInputMethods() {
        return this.hostAdapterLocator != null && this.javaInputMethodCount > 0 || this.javaInputMethodCount > 1;
    }

    private synchronized void waitForChangeRequest() {
        try {
            while (this.requestComponent == null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeInputMethodLocatorList() {
        Vector vector = this.javaInputMethodLocatorList;
        synchronized (vector) {
            this.javaInputMethodLocatorList.clear();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        Iterator iterator = Service.installedProviders(class$java$awt$im$spi$InputMethodDescriptor == null ? (class$java$awt$im$spi$InputMethodDescriptor = ExecutableInputMethodManager.class$("java.awt.im.spi.InputMethodDescriptor")) : class$java$awt$im$spi$InputMethodDescriptor);
                        while (iterator.hasNext()) {
                            InputMethodDescriptor inputMethodDescriptor = (InputMethodDescriptor)iterator.next();
                            ClassLoader classLoader = inputMethodDescriptor.getClass().getClassLoader();
                            ExecutableInputMethodManager.this.javaInputMethodLocatorList.add(new InputMethodLocator(inputMethodDescriptor, classLoader, null));
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
            this.javaInputMethodCount = this.javaInputMethodLocatorList.size();
        }
        if (!this.hasMultipleInputMethods()) {
            this.triggerMenuString = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInputMethodMenu() {
        Object object;
        if (!this.hasMultipleInputMethods()) {
            this.requestComponent = null;
            return;
        }
        this.selectionMenu.removeAll();
        String string = this.getCurrentSelection();
        if (this.hostAdapterLocator != null) {
            this.addOneInputMethodToMenu(this.hostAdapterLocator, string);
            this.selectionMenu.addSeparator();
        }
        int n2 = 0;
        while (n2 < this.javaInputMethodLocatorList.size()) {
            object = (InputMethodLocator)this.javaInputMethodLocatorList.get(n2);
            this.addOneInputMethodToMenu((InputMethodLocator)object, string);
            ++n2;
        }
        object = this;
        synchronized (object) {
            this.requestComponent.add(this.selectionMenu);
            this.requestInputContext = this.currentInputContext;
            this.selectionMenu.show(this.requestComponent, 60, 80);
            this.requestComponent = null;
        }
    }

    private String getCurrentSelection() {
        InputMethodLocator inputMethodLocator;
        InputContext inputContext = this.currentInputContext;
        if (inputContext != null && (inputMethodLocator = inputContext.getInputMethodLocator()) != null) {
            return inputMethodLocator.getActionCommandString();
        }
        return null;
    }

    private void addOneInputMethodToMenu(InputMethodLocator inputMethodLocator, String string) {
        int n2;
        InputMethodDescriptor inputMethodDescriptor = inputMethodLocator.getDescriptor();
        String string2 = inputMethodDescriptor.getInputMethodDisplayName(null, Locale.getDefault());
        String string3 = inputMethodLocator.getActionCommandString();
        Locale[] localeArray = null;
        try {
            localeArray = inputMethodDescriptor.getAvailableLocales();
            n2 = localeArray.length;
        }
        catch (AWTException aWTException) {
            n2 = 0;
        }
        if (n2 == 0) {
            this.addMenuItem(this.selectionMenu, string2, null, string);
        } else if (n2 == 1) {
            if (inputMethodDescriptor.hasDynamicLocaleList()) {
                string2 = inputMethodDescriptor.getInputMethodDisplayName(localeArray[0], Locale.getDefault());
                string3 = inputMethodLocator.deriveLocator(localeArray[0]).getActionCommandString();
            }
            this.addMenuItem(this.selectionMenu, string2, string3, string);
        } else {
            Menu menu = new Menu(string2);
            this.selectionMenu.add(menu);
            int n3 = 0;
            while (n3 < n2) {
                Locale locale = localeArray[n3];
                String string4 = this.getLocaleName(locale);
                String string5 = inputMethodLocator.deriveLocator(locale).getActionCommandString();
                this.addMenuItem(menu, string4, string5, string);
                ++n3;
            }
        }
    }

    private MenuItem addMenuItem(Menu menu, String string, String string2, String string3) {
        MenuItem menuItem = ExecutableInputMethodManager.isSelected(string2, string3) ? new CheckboxMenuItem(string, true) : new MenuItem(string);
        menuItem.setActionCommand(string2);
        menuItem.addActionListener(this);
        menuItem.setEnabled(string2 != null);
        menu.add(menuItem);
        return menuItem;
    }

    private static boolean isSelected(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        int n2 = string2.indexOf(10);
        return n2 != -1 && string2.substring(0, n2).equals(string);
    }

    private String getLocaleName(Locale locale) {
        String string = locale.toString();
        String string2 = Toolkit.getProperty("AWT.InputMethodLanguage." + string, null);
        if (string2 == null && ((string2 = locale.getDisplayName()) == null || string2.length() == 0)) {
            string2 = string;
        }
        return string2;
    }

    private void changeInputMethod(String string) {
        String string2;
        Object object;
        Object object2 = null;
        String string3 = string;
        String string4 = null;
        int n2 = string.indexOf(10);
        if (n2 != -1) {
            string4 = string.substring(n2 + 1);
            string3 = string.substring(0, n2);
        }
        if (this.hostAdapterLocator.getActionCommandString().equals(string3)) {
            object2 = this.hostAdapterLocator;
        } else {
            int n3 = 0;
            while (n3 < this.javaInputMethodLocatorList.size()) {
                object = (InputMethodLocator)this.javaInputMethodLocatorList.get(n3);
                string2 = ((InputMethodLocator)object).getActionCommandString();
                if (string2.equals(string3)) {
                    object2 = object;
                    break;
                }
                ++n3;
            }
        }
        if (object2 != null && string4 != null) {
            String string5 = "";
            object = "";
            string2 = "";
            int n4 = string4.indexOf(95);
            if (n4 == -1) {
                string5 = string4;
            } else {
                string5 = string4.substring(0, n4);
                int n5 = n4 + 1;
                if ((n4 = string4.indexOf(95, n5)) == -1) {
                    object = string4.substring(n5);
                } else {
                    object = string4.substring(n5, n4);
                    string2 = string4.substring(n4 + 1);
                }
            }
            Locale locale = new Locale(string5, (String)object, string2);
            object2 = ((InputMethodLocator)object2).deriveLocator(locale);
        }
        if (object2 == null) {
            return;
        }
        if (this.requestInputContext != null) {
            this.requestInputContext.changeInputMethod((InputMethodLocator)object2);
            this.requestInputContext = null;
            this.putPreferredInputMethod((InputMethodLocator)object2);
        }
    }

    InputMethodLocator findInputMethod(Locale locale) {
        InputMethodLocator inputMethodLocator = this.getPreferredInputMethod(locale);
        if (inputMethodLocator != null) {
            return inputMethodLocator;
        }
        if (this.hostAdapterLocator != null && this.hostAdapterLocator.isLocaleAvailable(locale)) {
            return this.hostAdapterLocator.deriveLocator(locale);
        }
        this.initializeInputMethodLocatorList();
        int n2 = 0;
        while (n2 < this.javaInputMethodLocatorList.size()) {
            InputMethodLocator inputMethodLocator2 = (InputMethodLocator)this.javaInputMethodLocatorList.get(n2);
            if (inputMethodLocator2.isLocaleAvailable(locale)) {
                return inputMethodLocator2.deriveLocator(locale);
            }
            ++n2;
        }
        return null;
    }

    Locale getDefaultKeyboardLocale() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof InputMethodSupport) {
            return ((InputMethodSupport)((Object)toolkit)).getDefaultKeyboardLocale();
        }
        return Locale.getDefault();
    }

    private synchronized InputMethodLocator getPreferredInputMethod(Locale locale) {
        InputMethodLocator inputMethodLocator = null;
        inputMethodLocator = (InputMethodLocator)this.preferredLocatorCache.get(locale.toString().intern());
        if (inputMethodLocator != null) {
            return inputMethodLocator;
        }
        String string = this.findPreferredInputMethodNode(locale);
        String string2 = this.readPreferredInputMethod(string);
        if (string2 != null) {
            if (this.hostAdapterLocator != null && this.hostAdapterLocator.getDescriptor().getClass().getName().equals(string2)) {
                Locale locale2 = this.getAdvertisedLocale(this.hostAdapterLocator, locale);
                if (locale2 != null) {
                    inputMethodLocator = this.hostAdapterLocator.deriveLocator(locale2);
                    this.preferredLocatorCache.put(locale.toString().intern(), inputMethodLocator);
                }
                return inputMethodLocator;
            }
            int n2 = 0;
            while (n2 < this.javaInputMethodLocatorList.size()) {
                InputMethodLocator inputMethodLocator2 = (InputMethodLocator)this.javaInputMethodLocatorList.get(n2);
                InputMethodDescriptor inputMethodDescriptor = inputMethodLocator2.getDescriptor();
                if (inputMethodDescriptor.getClass().getName().equals(string2)) {
                    Locale locale3 = this.getAdvertisedLocale(inputMethodLocator2, locale);
                    if (locale3 != null) {
                        inputMethodLocator = inputMethodLocator2.deriveLocator(locale3);
                        this.preferredLocatorCache.put(locale.toString().intern(), inputMethodLocator);
                    }
                    return inputMethodLocator;
                }
                ++n2;
            }
            this.writePreferredInputMethod(string, null);
        }
        return null;
    }

    private String findPreferredInputMethodNode(Locale locale) {
        if (this.userRoot == null) {
            return null;
        }
        String string = "/sun/awt/im/preferredInputMethod/" + this.createLocalePath(locale);
        while (!string.equals(preferredIMNode)) {
            try {
                if (this.userRoot.nodeExists(string) && this.readPreferredInputMethod(string) != null) {
                    return string;
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            string = string.substring(0, string.lastIndexOf(47));
        }
        return null;
    }

    private String readPreferredInputMethod(String string) {
        if (this.userRoot == null || string == null) {
            return null;
        }
        return this.userRoot.node(string).get(descriptorKey, null);
    }

    private synchronized void putPreferredInputMethod(InputMethodLocator inputMethodLocator) {
        Object object;
        InputMethodDescriptor inputMethodDescriptor = inputMethodLocator.getDescriptor();
        Locale locale = inputMethodLocator.getLocale();
        if (locale == null) {
            try {
                object = inputMethodDescriptor.getAvailableLocales();
                if (((Locale[])object).length != 1) {
                    return;
                }
                locale = object[0];
            }
            catch (AWTException aWTException) {
                return;
            }
        }
        if (locale.equals(Locale.JAPAN)) {
            locale = Locale.JAPANESE;
        }
        if (locale.equals(Locale.KOREA)) {
            locale = Locale.KOREAN;
        }
        if (locale.equals(new Locale("th", "TH"))) {
            locale = new Locale("th");
        }
        object = "/sun/awt/im/preferredInputMethod/" + this.createLocalePath(locale);
        this.writePreferredInputMethod((String)object, inputMethodDescriptor.getClass().getName());
        this.preferredLocatorCache.put(locale.toString().intern(), inputMethodLocator.deriveLocator(locale));
    }

    private String createLocalePath(Locale locale) {
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        String string4 = null;
        string4 = !string3.equals("") ? "_" + string + "/_" + string2 + "/_" + string3 : (!string2.equals("") ? "_" + string + "/_" + string2 : "_" + string);
        return string4;
    }

    private void writePreferredInputMethod(String string, String string2) {
        if (this.userRoot != null) {
            Preferences preferences = this.userRoot.node(string);
            if (string2 != null) {
                preferences.put(descriptorKey, string2);
            } else {
                preferences.remove(descriptorKey);
            }
        }
    }

    private Preferences getUserRoot() {
        return (Preferences)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Preferences.userRoot();
            }
        });
    }

    private Locale getAdvertisedLocale(InputMethodLocator inputMethodLocator, Locale locale) {
        Locale locale2 = null;
        if (inputMethodLocator.isLocaleAvailable(locale)) {
            locale2 = locale;
        } else if (locale.getLanguage().equals("ja")) {
            if (inputMethodLocator.isLocaleAvailable(Locale.JAPAN)) {
                locale2 = Locale.JAPAN;
            } else if (inputMethodLocator.isLocaleAvailable(Locale.JAPANESE)) {
                locale2 = Locale.JAPANESE;
            }
        } else if (locale.getLanguage().equals("ko")) {
            if (inputMethodLocator.isLocaleAvailable(Locale.KOREA)) {
                locale2 = Locale.KOREA;
            } else if (inputMethodLocator.isLocaleAvailable(Locale.KOREAN)) {
                locale2 = Locale.KOREAN;
            }
        } else if (locale.getLanguage().equals("th")) {
            if (inputMethodLocator.isLocaleAvailable(new Locale("th", "TH"))) {
                locale2 = new Locale("th", "TH");
            } else if (inputMethodLocator.isLocaleAvailable(new Locale("th"))) {
                locale2 = new Locale("th");
            }
        }
        return locale2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

