/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;

public class StylesheetComposed
extends Stylesheet {
    private int m_importNumber = -1;
    private int m_importCountComposed;
    private transient Vector m_includesComposed;

    public StylesheetComposed(Stylesheet stylesheet) {
        super(stylesheet);
    }

    public boolean isAggregatedType() {
        return true;
    }

    public void recompose(Vector vector) throws TransformerException {
        this.recomposeImports();
        this.recomposeIncludes(this);
        int n2 = this.getIncludeCountComposed();
        int n3 = -1;
        while (n3 < n2) {
            Stylesheet stylesheet = this.getIncludeComposed(n3);
            int n4 = stylesheet.getOutputCount();
            int n5 = 0;
            while (n5 < n4) {
                vector.addElement(stylesheet.getOutput(n5));
                ++n5;
            }
            n4 = stylesheet.getAttributeSetCount();
            int n6 = 0;
            while (n6 < n4) {
                vector.addElement(stylesheet.getAttributeSet(n6));
                ++n6;
            }
            n4 = stylesheet.getDecimalFormatCount();
            int n7 = 0;
            while (n7 < n4) {
                vector.addElement(stylesheet.getDecimalFormat(n7));
                ++n7;
            }
            n4 = stylesheet.getKeyCount();
            int n8 = 0;
            while (n8 < n4) {
                vector.addElement(stylesheet.getKey(n8));
                ++n8;
            }
            n4 = stylesheet.getNamespaceAliasCount();
            int n9 = 0;
            while (n9 < n4) {
                vector.addElement(stylesheet.getNamespaceAlias(n9));
                ++n9;
            }
            n4 = stylesheet.getTemplateCount();
            int n10 = 0;
            while (n10 < n4) {
                vector.addElement(stylesheet.getTemplate(n10));
                ++n10;
            }
            n4 = stylesheet.getVariableOrParamCount();
            int n11 = 0;
            while (n11 < n4) {
                vector.addElement(stylesheet.getVariableOrParam(n11));
                ++n11;
            }
            n4 = stylesheet.getStripSpaceCount();
            int n12 = 0;
            while (n12 < n4) {
                vector.addElement(stylesheet.getStripSpace(n12));
                ++n12;
            }
            n4 = stylesheet.getPreserveSpaceCount();
            int n13 = 0;
            while (n13 < n4) {
                vector.addElement(stylesheet.getPreserveSpace(n13));
                ++n13;
            }
            ++n3;
        }
    }

    void recomposeImports() {
        this.m_importNumber = this.getStylesheetRoot().getImportNumber(this);
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        int n2 = stylesheetRoot.getGlobalImportCount();
        this.m_importCountComposed = n2 - this.m_importNumber - 1;
    }

    public StylesheetComposed getImportComposed(int n2) throws ArrayIndexOutOfBoundsException {
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        return stylesheetRoot.getGlobalImport(1 + this.m_importNumber + n2);
    }

    public int getImportCountComposed() {
        return this.m_importCountComposed;
    }

    void recomposeIncludes(Stylesheet stylesheet) {
        int n2 = stylesheet.getIncludeCount();
        if (n2 > 0) {
            if (null == this.m_includesComposed) {
                this.m_includesComposed = new Vector();
            }
            int n3 = 0;
            while (n3 < n2) {
                Stylesheet stylesheet2 = stylesheet.getInclude(n3);
                this.m_includesComposed.addElement(stylesheet2);
                this.recomposeIncludes(stylesheet2);
                ++n3;
            }
        }
    }

    public Stylesheet getIncludeComposed(int n2) throws ArrayIndexOutOfBoundsException {
        if (-1 == n2) {
            return this;
        }
        if (null == this.m_includesComposed) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Stylesheet)this.m_includesComposed.elementAt(n2);
    }

    public int getIncludeCountComposed() {
        return null != this.m_includesComposed ? this.m_includesComposed.size() : 0;
    }

    public void recomposeTemplates(boolean bl2) throws TransformerException {
    }
}

