/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicHTML;

public class BasicButtonListener
implements MouseListener,
MouseMotionListener,
FocusListener,
ChangeListener,
PropertyChangeListener {
    private boolean createdWindowInputMap;
    transient long lastPressedTimestamp = -1L;
    transient boolean shouldDiscardRelease = false;

    public BasicButtonListener(AbstractButton abstractButton) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("mnemonic")) {
            this.updateMnemonicBinding((AbstractButton)propertyChangeEvent.getSource());
        }
        if (string.equals("contentAreaFilled")) {
            this.checkOpacity((AbstractButton)propertyChangeEvent.getSource());
        }
        if (string.equals("text") || "font".equals(string) || "foreground".equals(string)) {
            AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
            BasicHTML.updateRenderer(abstractButton, abstractButton.getText());
        }
    }

    protected void checkOpacity(AbstractButton abstractButton) {
        abstractButton.setOpaque(abstractButton.isContentAreaFilled());
    }

    public void installKeyboardActions(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.updateMnemonicBinding(abstractButton);
        ActionMap actionMap = this.getActionMap(abstractButton);
        SwingUtilities.replaceUIActionMap(jComponent, actionMap);
        InputMap inputMap = this.getInputMap(0, jComponent);
        SwingUtilities.replaceUIInputMap(jComponent, 0, inputMap);
    }

    public void uninstallKeyboardActions(JComponent jComponent) {
        if (this.createdWindowInputMap) {
            SwingUtilities.replaceUIInputMap(jComponent, 2, null);
            this.createdWindowInputMap = false;
        }
        SwingUtilities.replaceUIInputMap(jComponent, 0, null);
        SwingUtilities.replaceUIActionMap(jComponent, null);
    }

    ActionMap getActionMap(AbstractButton abstractButton) {
        return this.createActionMap(abstractButton);
    }

    InputMap getInputMap(int n2, JComponent jComponent) {
        ButtonUI buttonUI;
        if (n2 == 0 && (buttonUI = ((AbstractButton)jComponent).getUI()) != null && buttonUI instanceof BasicButtonUI) {
            return (InputMap)UIManager.get(((BasicButtonUI)buttonUI).getPropertyPrefix() + "focusInputMap");
        }
        return null;
    }

    ActionMap createActionMap(AbstractButton abstractButton) {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("pressed", new PressedAction(abstractButton));
        actionMapUIResource.put("released", new ReleasedAction(abstractButton));
        return actionMapUIResource;
    }

    void updateMnemonicBinding(AbstractButton abstractButton) {
        InputMap inputMap;
        int n2 = abstractButton.getMnemonic();
        if (n2 != 0) {
            InputMap inputMap2;
            if (!this.createdWindowInputMap) {
                inputMap2 = new ComponentInputMapUIResource(abstractButton);
                SwingUtilities.replaceUIInputMap(abstractButton, 2, inputMap2);
                this.createdWindowInputMap = true;
            } else {
                inputMap2 = SwingUtilities.getUIInputMap(abstractButton, 2);
            }
            if (inputMap2 != null) {
                inputMap2.clear();
                inputMap2.put(KeyStroke.getKeyStroke(n2, 8, false), "pressed");
                inputMap2.put(KeyStroke.getKeyStroke(n2, 8, true), "released");
                inputMap2.put(KeyStroke.getKeyStroke(n2, 0, true), "released");
            }
        } else if (this.createdWindowInputMap && (inputMap = SwingUtilities.getUIInputMap(abstractButton, 2)) != null) {
            inputMap.clear();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
        abstractButton.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
        JRootPane jRootPane;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        if (abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultCapable() && (jRootPane = abstractButton.getRootPane()) != null) {
            jRootPane.putClientProperty("temporaryDefaultButton", abstractButton);
            jRootPane.setDefaultButton((JButton)abstractButton);
            jRootPane.putClientProperty("temporaryDefaultButton", null);
        }
        abstractButton.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        JButton jButton;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        JRootPane jRootPane = abstractButton.getRootPane();
        if (jRootPane != null && abstractButton != (jButton = (JButton)jRootPane.getClientProperty("initialDefaultButton"))) {
            jRootPane.setDefaultButton(jButton);
        }
        abstractButton.getModel().setArmed(false);
        abstractButton.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        AbstractButton abstractButton;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && (abstractButton = (AbstractButton)mouseEvent.getSource()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            long l2 = abstractButton.getMultiClickThreshhold();
            long l3 = this.lastPressedTimestamp;
            long l4 = this.lastPressedTimestamp = mouseEvent.getWhen();
            if (l3 != -1L && l4 - l3 < l2) {
                this.shouldDiscardRelease = true;
                return;
            }
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            if (!buttonModel.isArmed()) {
                buttonModel.setArmed(true);
            }
            buttonModel.setPressed(true);
            if (!abstractButton.hasFocus() && abstractButton.isRequestFocusEnabled()) {
                abstractButton.requestFocus();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.shouldDiscardRelease) {
                this.shouldDiscardRelease = false;
                return;
            }
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            buttonModel.setPressed(false);
            buttonModel.setArmed(false);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(true);
        }
        if (buttonModel.isPressed()) {
            buttonModel.setArmed(true);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(false);
        }
        buttonModel.setArmed(false);
    }

    static class ReleasedAction
    extends AbstractAction {
        AbstractButton b = null;

        ReleasedAction(AbstractButton abstractButton) {
            this.b = abstractButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ButtonModel buttonModel = this.b.getModel();
            buttonModel.setPressed(false);
            buttonModel.setArmed(false);
        }

        public boolean isEnabled() {
            return this.b.getModel().isEnabled();
        }
    }

    static class PressedAction
    extends AbstractAction {
        AbstractButton b = null;

        PressedAction(AbstractButton abstractButton) {
            this.b = abstractButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ButtonModel buttonModel = this.b.getModel();
            buttonModel.setArmed(true);
            buttonModel.setPressed(true);
            if (!this.b.hasFocus()) {
                this.b.requestFocus();
            }
        }

        public boolean isEnabled() {
            return this.b.getModel().isEnabled();
        }
    }
}

