/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.EmptyBorder;

public class MatteBorder
extends EmptyBorder {
    protected Color color;
    protected Icon tileIcon;

    public MatteBorder(int n2, int n3, int n4, int n5, Color color) {
        super(n2, n3, n4, n5);
        this.color = color;
    }

    public MatteBorder(Insets insets, Color color) {
        super(insets);
        this.color = color;
    }

    public MatteBorder(int n2, int n3, int n4, int n5, Icon icon) {
        super(n2, n3, n4, n5);
        this.tileIcon = icon;
    }

    public MatteBorder(Insets insets, Icon icon) {
        super(insets);
        this.tileIcon = icon;
    }

    public MatteBorder(Icon icon) {
        this(-1, -1, -1, -1, icon);
    }

    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        Insets insets = this.getBorderInsets(component);
        Color color = graphics.getColor();
        graphics.translate(n2, n3);
        if (this.tileIcon != null) {
            Color color2 = this.color = this.tileIcon.getIconWidth() == -1 ? Color.gray : null;
        }
        if (this.color != null) {
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, n4 - insets.right, insets.top);
            graphics.fillRect(0, insets.top, insets.left, n5 - insets.top);
            graphics.fillRect(insets.left, n5 - insets.bottom, n4 - insets.left, insets.bottom);
            graphics.fillRect(n4 - insets.right, 0, insets.right, n5 - insets.bottom);
        } else if (this.tileIcon != null) {
            int n6;
            int n7 = this.tileIcon.getIconWidth();
            int n8 = this.tileIcon.getIconHeight();
            Graphics graphics2 = graphics.create();
            graphics2.setClip(0, 0, n4, insets.top);
            int n9 = 0;
            while (insets.top - n9 > 0) {
                n6 = 0;
                while (n4 - n6 > 0) {
                    this.tileIcon.paintIcon(component, graphics2, n6, n9);
                    n6 += n7;
                }
                n9 += n8;
            }
            graphics2.dispose();
            graphics2 = graphics.create();
            graphics2.setClip(0, insets.top, insets.left, n5 - insets.top);
            int n10 = insets.top - insets.top % n8;
            int n11 = 0;
            n9 = n10;
            while (n5 - n9 > 0) {
                n6 = n11;
                while (insets.left - n6 > 0) {
                    this.tileIcon.paintIcon(component, graphics2, n6, n9);
                    n6 += n7;
                }
                n9 += n8;
            }
            graphics2.dispose();
            graphics2 = graphics.create();
            graphics2.setClip(insets.left, n5 - insets.bottom, n4 - insets.left, insets.bottom);
            n10 = n5 - insets.bottom - (n5 - insets.bottom) % n8;
            n11 = insets.left - insets.left % n7;
            n9 = n10;
            while (n5 - n9 > 0) {
                n6 = n11;
                while (n4 - n6 > 0) {
                    this.tileIcon.paintIcon(component, graphics2, n6, n9);
                    n6 += n7;
                }
                n9 += n8;
            }
            graphics2.dispose();
            graphics2 = graphics.create();
            graphics2.setClip(n4 - insets.right, insets.top, insets.right, n5 - insets.top - insets.bottom);
            n10 = insets.top - insets.top % n8;
            n11 = n4 - insets.right - (n4 - insets.right) % n7;
            n9 = n10;
            while (n5 - n9 > 0) {
                n6 = n11;
                while (n4 - n6 > 0) {
                    this.tileIcon.paintIcon(component, graphics2, n6, n9);
                    n6 += n7;
                }
                n9 += n8;
            }
            graphics2.dispose();
        }
        graphics.translate(-n2, -n3);
        graphics.setColor(color);
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets();
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        return this.computeInsets(insets);
    }

    public Insets getBorderInsets() {
        return this.computeInsets(new Insets(0, 0, 0, 0));
    }

    private Insets computeInsets(Insets insets) {
        if (this.tileIcon != null && this.top == -1 && this.bottom == -1 && this.left == -1 && this.right == -1) {
            int n2;
            int n3 = this.tileIcon.getIconWidth();
            insets.top = n2 = this.tileIcon.getIconHeight();
            insets.right = n3;
            insets.bottom = n2;
            insets.left = n3;
        } else {
            insets.left = this.left;
            insets.top = this.top;
            insets.right = this.right;
            insets.bottom = this.bottom;
        }
        return insets;
    }

    public Color getMatteColor() {
        return this.color;
    }

    public Icon getTileIcon() {
        return this.tileIcon;
    }

    public boolean isBorderOpaque() {
        return this.color != null;
    }
}

