/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;

public class Attributes
implements Map,
Cloneable {
    protected Map map;

    public Attributes() {
        this(11);
    }

    public Attributes(int n2) {
        this.map = new HashMap(n2);
    }

    public Attributes(Attributes attributes) {
        this.map = new HashMap(attributes);
    }

    public Object get(Object object) {
        return this.map.get(object);
    }

    public String getValue(String string) {
        return (String)this.get(new Name(string));
    }

    public String getValue(Name name) {
        return (String)this.get(name);
    }

    public Object put(Object object, Object object2) {
        return this.map.put((Name)object, (String)object2);
    }

    public String putValue(String string, String string2) {
        return (String)this.put(new Name(string), string2);
    }

    public Object remove(Object object) {
        return this.map.remove(object);
    }

    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public void putAll(Map map) {
        this.map.putAll((Attributes)map);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public Object clone() {
        return new Attributes(this);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            StringBuffer stringBuffer = new StringBuffer(((Name)entry.getKey()).toString());
            stringBuffer.append(": ");
            stringBuffer.append((String)entry.getValue());
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
        }
        dataOutputStream.writeBytes("\r\n");
    }

    void writeMain(DataOutputStream dataOutputStream) throws IOException {
        String string = Name.MANIFEST_VERSION.toString();
        String string2 = this.getValue(string);
        if (string2 == null) {
            string = Name.SIGNATURE_VERSION.toString();
            string2 = this.getValue(string);
        }
        if (string2 != null) {
            dataOutputStream.writeBytes(string + ": " + string2 + "\r\n");
        }
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string3 = ((Name)entry.getKey()).toString();
            if (string2 == null || string3.equalsIgnoreCase(string)) continue;
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append(": ");
            stringBuffer.append((String)entry.getValue());
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
        }
        dataOutputStream.writeBytes("\r\n");
    }

    /*
     * Unable to fully structure code
     */
    void read(Manifest.FastInputStream var1_1, byte[] var2_2) throws IOException {
        var3_3 = null;
        var4_4 = null;
        while ((var5_5 = var1_1.readLine(var2_2)) != -1) {
            block8: {
                if (var2_2[--var5_5] != 10) {
                    throw new IOException("line too long");
                }
                if (var5_5 > 0 && var2_2[var5_5 - 1] == 13) {
                    --var5_5;
                }
                if (var5_5 == 0) break;
                var6_6 = 0;
                if (var2_2[0] != 32) ** GOTO lbl17
                if (var3_3 == null) {
                    throw new IOException("misplaced continuation line");
                }
                var4_4 = var4_4 + new String(var2_2, 0, 1, var5_5 - 1);
                break block8;
lbl-1000:
                // 1 sources

                {
                    if (var6_6 < var5_5) continue;
                    throw new IOException("invalid header field");
lbl17:
                    // 2 sources

                    ** while (var2_2[var6_6++] != 58)
                }
lbl18:
                // 1 sources

                if (var2_2[var6_6++] != 32) {
                    throw new IOException("invalid header field");
                }
                var3_3 = new String(var2_2, 0, 0, var6_6 - 2);
                var4_4 = new String(var2_2, 0, var6_6, var5_5 - var6_6);
            }
            try {
                this.putValue(var3_3, var4_4);
            }
            catch (IllegalArgumentException var7_7) {
                throw new IOException("invalid header field name: " + var3_3);
            }
        }
    }

    public static class Name {
        private String name;
        private int hashCode = -1;
        public static final Name MANIFEST_VERSION = new Name("Manifest-Version");
        public static final Name SIGNATURE_VERSION = new Name("Signature-Version");
        public static final Name CONTENT_TYPE = new Name("Content-Type");
        public static final Name CLASS_PATH = new Name("Class-Path");
        public static final Name MAIN_CLASS = new Name("Main-Class");
        public static final Name SEALED = new Name("Sealed");
        public static final Name EXTENSION_LIST = new Name("Extension-List");
        public static final Name EXTENSION_NAME = new Name("Extension-Name");
        public static final Name EXTENSION_INSTALLATION = new Name("Extension-Installation");
        public static final Name IMPLEMENTATION_TITLE = new Name("Implementation-Title");
        public static final Name IMPLEMENTATION_VERSION = new Name("Implementation-Version");
        public static final Name IMPLEMENTATION_VENDOR = new Name("Implementation-Vendor");
        public static final Name IMPLEMENTATION_VENDOR_ID = new Name("Implementation-Vendor-Id");
        public static final Name IMPLEMENTATION_URL = new Name("Implementation-URL");
        public static final Name SPECIFICATION_TITLE = new Name("Specification-Title");
        public static final Name SPECIFICATION_VERSION = new Name("Specification-Version");
        public static final Name SPECIFICATION_VENDOR = new Name("Specification-Vendor");

        public Name(String string) {
            if (string == null) {
                throw new NullPointerException("name");
            }
            if (!Name.isValid(string)) {
                throw new IllegalArgumentException(string);
            }
            this.name = string.intern();
        }

        private static boolean isValid(String string) {
            int n2 = string.length();
            if (n2 > 70 || n2 == 0) {
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (!Name.isValid(string.charAt(n3))) {
                    return false;
                }
                ++n3;
            }
            return true;
        }

        private static boolean isValid(char c2) {
            return Name.isAlpha(c2) || Name.isDigit(c2) || c2 == '_' || c2 == '-';
        }

        private static boolean isAlpha(char c2) {
            return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z';
        }

        private static boolean isDigit(char c2) {
            return c2 >= '0' && c2 <= '9';
        }

        public boolean equals(Object object) {
            if (object instanceof Name) {
                return this.name.equalsIgnoreCase(((Name)object).name);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = this.name.toLowerCase().hashCode();
            }
            return this.hashCode;
        }

        public String toString() {
            return this.name;
        }
    }
}

