/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermissionCollection;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import sun.security.util.Debug;

public final class UnresolvedPermission
extends Permission
implements Serializable {
    private static final Debug debug = Debug.getInstance("policy,access", "UnresolvedPermission");
    private String type;
    private String name;
    private String actions;
    private transient Certificate[] certs;
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = UnresolvedPermission.class$("java.lang.String")) : class$java$lang$String};
    private static final Class[] PARAMS2 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = UnresolvedPermission.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = UnresolvedPermission.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;

    public UnresolvedPermission(String string, String string2, String string3, Certificate[] certificateArray) {
        super(string);
        if (string == null) {
            throw new NullPointerException("type can't be null");
        }
        this.type = string;
        this.name = string2;
        this.actions = string3;
        if (certificateArray != null) {
            int n2 = 0;
            while (n2 < certificateArray.length) {
                if (!(certificateArray[n2] instanceof X509Certificate)) {
                    this.certs = (Certificate[])certificateArray.clone();
                    break;
                }
                ++n2;
            }
            if (this.certs == null) {
                int n3 = 0;
                int n4 = 0;
                while (n3 < certificateArray.length) {
                    ++n4;
                    while (n3 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n3]).getIssuerDN().equals(((X509Certificate)certificateArray[n3 + 1]).getSubjectDN())) {
                        ++n3;
                    }
                    ++n3;
                }
                if (n4 == certificateArray.length) {
                    this.certs = (Certificate[])certificateArray.clone();
                }
                if (this.certs == null) {
                    ArrayList arrayList = new ArrayList();
                    n3 = 0;
                    while (n3 < certificateArray.length) {
                        arrayList.add(certificateArray[n3]);
                        while (n3 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n3]).getIssuerDN().equals(((X509Certificate)certificateArray[n3 + 1]).getSubjectDN())) {
                            ++n3;
                        }
                        ++n3;
                    }
                    this.certs = new Certificate[arrayList.size()];
                    arrayList.toArray(this.certs);
                }
            }
        }
    }

    Permission resolve(Permission permission, Certificate[] certificateArray) {
        if (this.certs != null) {
            if (certificateArray == null) {
                return null;
            }
            int n2 = 0;
            while (n2 < this.certs.length) {
                boolean bl2 = false;
                int n3 = 0;
                while (n3 < certificateArray.length) {
                    if (this.certs[n2].equals(certificateArray[n3])) {
                        bl2 = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl2) {
                    return null;
                }
                ++n2;
            }
        }
        try {
            Class clazz = permission.getClass();
            if (this.name == null && this.actions == null) {
                try {
                    Constructor constructor = clazz.getConstructor(PARAMS0);
                    return (Permission)constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        Constructor constructor = clazz.getConstructor(PARAMS1);
                        return (Permission)constructor.newInstance(new Object[]{this.name});
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        Constructor constructor = clazz.getConstructor(PARAMS2);
                        return (Permission)constructor.newInstance(new Object[]{this.name, this.actions});
                    }
                }
            }
            if (this.name != null && this.actions == null) {
                try {
                    Constructor constructor = clazz.getConstructor(PARAMS1);
                    return (Permission)constructor.newInstance(new Object[]{this.name});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Constructor constructor = clazz.getConstructor(PARAMS2);
                    return (Permission)constructor.newInstance(new Object[]{this.name, this.actions});
                }
            }
            Constructor constructor = clazz.getConstructor(PARAMS2);
            return (Permission)constructor.newInstance(new Object[]{this.name, this.actions});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (debug != null) {
                debug.println("NoSuchMethodException:\n  could not find proper constructor for " + this.type);
                noSuchMethodException.printStackTrace();
            }
            return null;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("unable to instantiate " + this.name);
                exception.printStackTrace();
            }
            return null;
        }
    }

    public boolean implies(Permission permission) {
        return false;
    }

    public boolean equals(Object object) {
        int n2;
        boolean bl2;
        if (object == this) {
            return true;
        }
        if (!(object instanceof UnresolvedPermission)) {
            return false;
        }
        UnresolvedPermission unresolvedPermission = (UnresolvedPermission)object;
        if (!this.type.equals(unresolvedPermission.type)) {
            return false;
        }
        if (this.name == null ? unresolvedPermission.name != null : !this.name.equals(unresolvedPermission.name)) {
            return false;
        }
        if (this.actions == null ? unresolvedPermission.actions != null : !this.actions.equals(unresolvedPermission.actions)) {
            return false;
        }
        if (this.certs == null && unresolvedPermission.certs != null || this.certs != null && unresolvedPermission.certs == null || this.certs != null && unresolvedPermission.certs != null && this.certs.length != unresolvedPermission.certs.length) {
            return false;
        }
        int n3 = 0;
        while (this.certs != null && n3 < this.certs.length) {
            bl2 = false;
            n2 = 0;
            while (n2 < unresolvedPermission.certs.length) {
                if (this.certs[n3].equals(unresolvedPermission.certs[n2])) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                return false;
            }
            ++n3;
        }
        n3 = 0;
        while (unresolvedPermission.certs != null && n3 < unresolvedPermission.certs.length) {
            bl2 = false;
            n2 = 0;
            while (n2 < this.certs.length) {
                if (unresolvedPermission.certs[n3].equals(this.certs[n2])) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.type.hashCode();
        if (this.name != null) {
            n2 ^= this.name.hashCode();
        }
        if (this.actions != null) {
            n2 ^= this.actions.hashCode();
        }
        return n2;
    }

    public String getActions() {
        return "";
    }

    public String toString() {
        return "(unresolved " + this.type + " " + this.name + " " + this.actions + ")";
    }

    public PermissionCollection newPermissionCollection() {
        return new UnresolvedPermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.certs == null || this.certs.length == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.certs.length);
            int n2 = 0;
            while (n2 < this.certs.length) {
                Certificate certificate = this.certs[n2];
                try {
                    objectOutputStream.writeUTF(certificate.getType());
                    byte[] byArray = certificate.getEncoded();
                    objectOutputStream.writeInt(byArray.length);
                    objectOutputStream.write(byArray);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException(certificateEncodingException.getMessage());
                }
                ++n2;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Hashtable hashtable = null;
        objectInputStream.defaultReadObject();
        if (this.type == null) {
            throw new NullPointerException("type can't be null");
        }
        int n2 = objectInputStream.readInt();
        if (n2 > 0) {
            hashtable = new Hashtable(3);
            this.certs = new Certificate[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            CertificateFactory certificateFactory;
            String string = objectInputStream.readUTF();
            if (hashtable.containsKey(string)) {
                certificateFactory = (CertificateFactory)hashtable.get(string);
            } else {
                try {
                    certificateFactory = CertificateFactory.getInstance(string);
                }
                catch (CertificateException certificateException) {
                    throw new ClassNotFoundException("Certificate factory for " + string + " not found");
                }
                hashtable.put(string, certificateFactory);
            }
            byte[] byArray = null;
            try {
                byArray = new byte[objectInputStream.readInt()];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException("Certificate too big");
            }
            objectInputStream.readFully(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                this.certs[n3] = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
            byteArrayInputStream.close();
            ++n3;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

