/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetEvent;
import java.util.List;

public class DropTargetDropEvent
extends DropTargetEvent {
    private static final long serialVersionUID = -1721911170440459322L;
    private static final Point zero = new Point(0, 0);
    private Point location = zero;
    private int actions = 0;
    private int dropAction = 0;
    private boolean isLocalTx = false;

    public DropTargetDropEvent(DropTargetContext dropTargetContext, Point point, int n2, int n3) {
        super(dropTargetContext);
        if (point == null) {
            throw new NullPointerException("cursorLocn");
        }
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 0x40000000) {
            throw new IllegalArgumentException("dropAction = " + n2);
        }
        if ((n3 & 0xBFFFFFFC) != 0) {
            throw new IllegalArgumentException("srcActions");
        }
        this.location = point;
        this.actions = n3;
        this.dropAction = n2;
    }

    public DropTargetDropEvent(DropTargetContext dropTargetContext, Point point, int n2, int n3, boolean bl2) {
        this(dropTargetContext, point, n2, n3);
        this.isLocalTx = bl2;
    }

    public Point getLocation() {
        return this.location;
    }

    public DataFlavor[] getCurrentDataFlavors() {
        return this.getDropTargetContext().getCurrentDataFlavors();
    }

    public List getCurrentDataFlavorsAsList() {
        return this.getDropTargetContext().getCurrentDataFlavorsAsList();
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.getDropTargetContext().isDataFlavorSupported(dataFlavor);
    }

    public int getSourceActions() {
        return this.actions;
    }

    public int getDropAction() {
        return this.dropAction;
    }

    public Transferable getTransferable() {
        return this.getDropTargetContext().getTransferable();
    }

    public void acceptDrop(int n2) {
        this.getDropTargetContext().acceptDrop(n2);
    }

    public void rejectDrop() {
        this.getDropTargetContext().rejectDrop();
    }

    public void dropComplete(boolean bl2) {
        this.getDropTargetContext().dropComplete(bl2);
    }

    public boolean isLocalTransfer() {
        return this.isLocalTx;
    }
}

