/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractMidiDeviceProvider;
import com.sun.media.sound.FastShortMessage;
import com.sun.media.sound.FastSysexMessage;
import java.util.Vector;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

class MidiOutDevice
extends AbstractMidiDevice {
    private Vector receivers = new Vector();

    MidiOutDevice(AbstractMidiDeviceProvider.Info info) {
        super(info);
    }

    synchronized void implOpen() throws MidiUnavailableException {
        this.id = this.nOpen(((AbstractMidiDeviceProvider.Info)this.getDeviceInfo()).getIndex());
        if (this.id == 0L) {
            throw new MidiUnavailableException("Unable to open native device");
        }
    }

    synchronized void implClose() {
        long l2 = this.id;
        this.id = 0L;
        int n2 = 0;
        while (n2 < this.receivers.size()) {
            ((Receiver)this.receivers.elementAt(n2)).close();
            ++n2;
        }
        this.receivers.removeAllElements();
        this.nClose(l2);
    }

    public int getMaxReceivers() {
        return -1;
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        MidiOutReceiver midiOutReceiver = new MidiOutReceiver();
        this.receivers.addElement(midiOutReceiver);
        return midiOutReceiver;
    }

    private native long nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(long var1);

    private native void nSendShortMessage(long var1, int var3, long var4);

    private native void nSendLongMessage(long var1, byte[] var3, int var4, long var5);

    class MidiOutReceiver
    implements Receiver {
        private boolean open = true;

        MidiOutReceiver() {
        }

        public synchronized void send(MidiMessage midiMessage, long l2) {
            if (this.open) {
                int n2 = midiMessage.getLength();
                if (n2 <= 3) {
                    int n3;
                    if (midiMessage instanceof ShortMessage) {
                        if (midiMessage instanceof FastShortMessage) {
                            n3 = ((FastShortMessage)midiMessage).getPackedMsg();
                        } else {
                            ShortMessage shortMessage = (ShortMessage)midiMessage;
                            n3 = shortMessage.getStatus() & 0xFF | (shortMessage.getData1() & 0xFF) << 8 | (shortMessage.getData2() & 0xFF) << 16;
                        }
                    } else {
                        n3 = 0;
                        byte[] byArray = midiMessage.getMessage();
                        if (n2 > 0) {
                            n3 = byArray[0] & 0xFF;
                            if (n2 > 1) {
                                n3 |= (byArray[1] & 0xFF) << 8;
                                if (n2 > 2) {
                                    n3 |= (byArray[2] & 0xFF) << 16;
                                }
                            }
                        }
                    }
                    MidiOutDevice.this.nSendShortMessage(MidiOutDevice.this.id, n3, l2);
                } else if (midiMessage instanceof FastSysexMessage) {
                    MidiOutDevice.this.nSendLongMessage(MidiOutDevice.this.id, ((FastSysexMessage)midiMessage).getReadOnlyMessage(), n2, l2);
                } else {
                    MidiOutDevice.this.nSendLongMessage(MidiOutDevice.this.id, midiMessage.getMessage(), n2, l2);
                }
            }
        }

        public void close() {
            MidiOutDevice.this.receivers.removeElement(this);
            this.open = false;
        }
    }
}

