/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifBorders;
import com.sun.java.swing.plaf.motif.MotifInternalFrameTitlePane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class MotifDesktopIconUI
extends BasicDesktopIconUI {
    protected DesktopIconActionListener desktopIconActionListener;
    protected DesktopIconMouseListener desktopIconMouseListener;
    protected Icon defaultIcon;
    protected IconButton iconButton;
    protected IconLabel iconLabel;
    JPopupMenu systemMenu;
    EventListener mml;
    static final int LABEL_HEIGHT = 18;
    static final int LABEL_DIVIDER = 4;
    static final Font defaultTitleFont = new Font("SansSerif", 0, 12);

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifDesktopIconUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.setDefaultIcon(UIManager.getIcon("DesktopIcon.icon"));
        this.iconButton = this.createIconButton(this.defaultIcon);
        MotifInternalFrameTitlePane motifInternalFrameTitlePane = new MotifInternalFrameTitlePane(this.frame);
        this.systemMenu = motifInternalFrameTitlePane.getSystemMenu();
        MotifBorders.FrameBorder frameBorder = new MotifBorders.FrameBorder(this.desktopIcon);
        this.desktopIcon.setLayout(new BorderLayout());
        this.iconButton.setBorder(frameBorder);
        this.desktopIcon.add((Component)this.iconButton, "Center");
        this.iconLabel = this.createIconLabel(this.frame);
        this.iconLabel.setBorder(frameBorder);
        this.desktopIcon.add((Component)this.iconLabel, "South");
        this.desktopIcon.setSize(this.desktopIcon.getPreferredSize());
        this.desktopIcon.validate();
        JLayeredPane.putLayer(this.desktopIcon, JLayeredPane.getLayer(this.frame));
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installListeners() {
        super.installListeners();
        this.desktopIconActionListener = this.createDesktopIconActionListener();
        this.desktopIconMouseListener = this.createDesktopIconMouseListener();
        this.iconButton.addActionListener(this.desktopIconActionListener);
        this.iconButton.addMouseListener(this.desktopIconMouseListener);
    }

    JInternalFrame.JDesktopIcon getDesktopIcon() {
        return this.desktopIcon;
    }

    void setDesktopIcon(JInternalFrame.JDesktopIcon jDesktopIcon) {
        this.desktopIcon = jDesktopIcon;
    }

    JInternalFrame getFrame() {
        return this.frame;
    }

    void setFrame(JInternalFrame jInternalFrame) {
        this.frame = jInternalFrame;
    }

    protected void showSystemMenu() {
        this.systemMenu.show(this.iconButton, 0, this.getDesktopIcon().getHeight());
    }

    protected void hideSystemMenu() {
        this.systemMenu.setVisible(false);
    }

    protected IconLabel createIconLabel(JInternalFrame jInternalFrame) {
        return new IconLabel(jInternalFrame);
    }

    protected IconButton createIconButton(Icon icon) {
        return new IconButton(icon);
    }

    protected DesktopIconActionListener createDesktopIconActionListener() {
        return new DesktopIconActionListener();
    }

    protected DesktopIconMouseListener createDesktopIconMouseListener() {
        return new DesktopIconMouseListener();
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconButton);
        this.desktopIcon.remove(this.iconLabel);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.iconButton.removeActionListener(this.desktopIconActionListener);
        this.iconButton.removeMouseListener(this.desktopIconMouseListener);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        int n2 = this.defaultIcon.getIconWidth();
        int n3 = this.defaultIcon.getIconHeight() + 18 + 4;
        Border border = jInternalFrame.getBorder();
        if (border != null) {
            n2 += border.getBorderInsets((Component)jInternalFrame).left + border.getBorderInsets((Component)jInternalFrame).right;
            n3 += border.getBorderInsets((Component)jInternalFrame).bottom + border.getBorderInsets((Component)jInternalFrame).top;
        }
        return new Dimension(n2, n3);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(Icon icon) {
        this.defaultIcon = icon;
    }

    protected class DesktopIconMouseListener
    extends MouseAdapter {
        protected DesktopIconMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                try {
                    MotifDesktopIconUI.this.getFrame().setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                MotifDesktopIconUI.this.systemMenu.setVisible(false);
                MotifDesktopIconUI.this.getFrame().getDesktopPane().getDesktopManager().endDraggingFrame((JComponent)mouseEvent.getSource());
            }
        }
    }

    protected class DesktopIconActionListener
    implements ActionListener {
        protected DesktopIconActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MotifDesktopIconUI.this.systemMenu.show(MotifDesktopIconUI.this.iconButton, 0, MotifDesktopIconUI.this.getDesktopIcon().getHeight());
        }
    }

    protected class IconButton
    extends JButton {
        Icon icon;

        IconButton(Icon icon) {
            super(icon);
            this.icon = icon;
            this.addMouseMotionListener(new MouseMotionListener(this){
                private final /* synthetic */ IconButton this$1;
                {
                    this.this$1 = iconButton;
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }
            });
            this.addMouseListener(new MouseListener(this){
                private final /* synthetic */ IconButton this$1;
                {
                    this.this$1 = iconButton;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (!IconButton.access$000((IconButton)this.this$1).systemMenu.isShowing()) {
                        this.this$1.forwardEventToParent(mouseEvent);
                    }
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }
            });
        }

        void forwardEventToParent(MouseEvent mouseEvent) {
            this.getParent().dispatchEvent(new MouseEvent(this.getParent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }

        public boolean isFocusTraversable() {
            return false;
        }

        static /* synthetic */ MotifDesktopIconUI access$000(IconButton iconButton) {
            return iconButton.MotifDesktopIconUI.this;
        }
    }

    protected class IconLabel
    extends JPanel {
        JInternalFrame frame;

        IconLabel(JInternalFrame jInternalFrame) {
            this.frame = jInternalFrame;
            this.setFont(defaultTitleFont);
            this.addMouseMotionListener(new MouseMotionListener(this){
                private final /* synthetic */ IconLabel this$1;
                {
                    this.this$1 = iconLabel;
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }
            });
            this.addMouseListener(new MouseListener(this){
                private final /* synthetic */ IconLabel this$1;
                {
                    this.this$1 = iconLabel;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.forwardEventToParent(mouseEvent);
                }
            });
        }

        void forwardEventToParent(MouseEvent mouseEvent) {
            this.getParent().dispatchEvent(new MouseEvent(this.getParent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public Dimension getMinimumSize() {
            return new Dimension(MotifDesktopIconUI.this.defaultIcon.getIconWidth() + 1, 22);
        }

        public Dimension getPreferredSize() {
            String string = this.frame.getTitle();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(defaultTitleFont);
            int n2 = 4;
            if (string != null) {
                n2 += fontMetrics.stringWidth(string);
            }
            return new Dimension(n2, 22);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n2 = this.getWidth() - 1;
            Color color = UIManager.getColor("inactiveCaptionBorder").darker().darker();
            graphics.setColor(color);
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            graphics.drawLine(n2 - 1, 1, n2 - 1, 1);
            graphics.drawLine(n2, 0, n2, 0);
            graphics.setColor(UIManager.getColor("inactiveCaption"));
            graphics.fillRect(2, 1, n2 - 3, 19);
            graphics.setClip(2, 1, n2 - 4, 18);
            int n3 = 18 - graphics.getFontMetrics().getDescent();
            graphics.setColor(UIManager.getColor("inactiveCaptionText"));
            String string = this.frame.getTitle();
            if (string != null) {
                graphics.drawString(string, 4, n3);
            }
        }
    }
}

