/*
 * Decompiled with CFR 0.152.
 */
package sun.net.spi.nameservice.dns;

import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import sun.net.dns.ResolverConfiguration;
import sun.net.spi.nameservice.NameService;
import sun.security.action.GetPropertyAction;

public final class DNSNameService
implements NameService {
    private LinkedList domainList = null;
    private String nameProviderUrl = null;
    private static ThreadLocal contextRef = new ThreadLocal();

    private DirContext getTemporaryContext() throws NamingException {
        SoftReference softReference = (SoftReference)contextRef.get();
        ThreadContext threadContext = null;
        List<String> list = null;
        if (this.nameProviderUrl == null) {
            list = ResolverConfiguration.open().nameservers();
        }
        if (softReference != null && (threadContext = (ThreadContext)softReference.get()) != null && this.nameProviderUrl == null && !threadContext.nameservers().equals(list)) {
            threadContext = null;
        }
        if (threadContext == null) {
            DirContext dirContext;
            final Properties properties = new Properties();
            properties.setProperty("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            String string = this.nameProviderUrl;
            if (string == null && (string = DNSNameService.createProviderURL(list)).length() == 0) {
                throw new RuntimeException("bad nameserver configuration");
            }
            properties.setProperty("java.naming.provider.url", string);
            try {
                dirContext = (DirContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NamingException {
                        return new InitialDirContext(properties);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NamingException)privilegedActionException.getException();
            }
            threadContext = new ThreadContext(dirContext, list);
            contextRef.set(new SoftReference<ThreadContext>(threadContext));
        }
        return threadContext.dirContext();
    }

    private Map resolve(final DirContext dirContext, final String string, final String[] stringArray) throws NamingException {
        HashMap hashMap = new HashMap();
        Attributes attributes = null;
        try {
            attributes = (Attributes)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return dirContext.getAttributes(string, stringArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (NamingException)privilegedActionException.getException();
        }
        if (attributes == null) {
            return null;
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
            Attribute attribute = namingEnumeration.next();
            String string2 = attribute.getID();
            ArrayList<String> arrayList = new ArrayList<String>();
            NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
            while (namingEnumeration2.hasMoreElements()) {
                String string3 = (String)namingEnumeration2.nextElement();
                arrayList.add(string3);
            }
            hashMap.put(string2, arrayList);
        }
        return hashMap;
    }

    public DNSNameService() throws Exception {
        String string;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.net.spi.nameservice.domain"));
        if (string2 != null && string2.length() > 0) {
            this.domainList = new LinkedList();
            this.domainList.add(string2);
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction("sun.net.spi.nameservice.nameservers"))) != null && string.length() > 0) {
            this.nameProviderUrl = DNSNameService.createProviderURL(string);
            if (this.nameProviderUrl.length() == 0) {
                throw new RuntimeException("malformed nameservers property");
            }
        } else {
            List<String> list = ResolverConfiguration.open().nameservers();
            if (list.size() == 0) {
                throw new RuntimeException("no nameservers provided");
            }
            boolean bl = false;
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                if (!DNSNameService.isIPv4LiteralAddress(string3) && !DNSNameService.isIPv6LiteralAddress(string3)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new RuntimeException("bad nameserver configuration");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public byte[][] lookupAllHostAddr(String var1_1) throws UnknownHostException {
        block12: {
            var2_2 = new String[]{"A", "AAAA", "CNAME"};
            try {
                var3_3 = this.getTemporaryContext();
            }
            catch (Exception var4_4) {
                throw new UnknownHostException(var4_4.getMessage());
            }
            var4_5 = null;
            try {
                var4_5 = this.resolve(var3_3, var1_1, var2_2);
                break block12;
            }
            catch (Exception var5_6) {
                var6_8 = this.domainList != null ? this.domainList.iterator() : ResolverConfiguration.open().searchlist().iterator();
                if (!var6_8.hasNext()) {
                    throw new UnknownHostException(var5_6.getMessage());
                }
                var7_9 = null;
                ** while (var6_8.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                var8_11 = (String)var6_8.next();
                var9_12 = 0;
                while ((var9_12 = var8_11.indexOf(".")) != -1 && var9_12 < var8_11.length() - 1) {
                    try {
                        var4_5 = this.resolve(var3_3, var1_1 + "." + (String)var8_11, var2_2);
                        var7_9 = null;
                        break;
                    }
                    catch (Exception var10_16) {
                        var8_11 = var8_11.substring(var9_12 + 1);
                        var7_9 = new UnknownHostException(var10_16.getMessage());
                    }
                }
                if (var7_9 == null) break;
                continue;
            }
lbl30:
            // 2 sources

            if (var7_9 != null) {
                throw var7_9;
            }
        }
        if (var4_5 == null) {
            throw new UnknownHostException(var1_1);
        }
        var5_7 = var4_5.entrySet();
        var6_8 = new ArrayList<E>();
        var7_10 = false;
        var8_11 = var5_7.iterator();
        while (var8_11.hasNext()) {
            var9_14 = (Map.Entry)var8_11.next();
            var6_8.add(InetAddress.getByName((String)((ArrayList)var9_14.getValue()).get(0)).getAddress());
        }
        var9_15 = new byte[var6_8.size()][];
        return (byte[][])var6_8.toArray((T[])var9_15);
    }

    public String getHostByAddr(byte[] byArray) throws UnknownHostException {
        try {
            int n;
            String string = "";
            if (byArray.length == 4) {
                n = byArray.length - 1;
                while (n >= 0) {
                    string = string + (byArray[n] & 0xFF) + ".";
                    --n;
                }
            } else if (byArray.length == 16) {
                n = byArray.length - 1;
                while (n >= 0) {
                    string = string + (byArray[n] & 0xF) + "." + (byArray[n] & 0xF0) + ".";
                    --n;
                }
            }
            if (byArray.length == 4) {
                string = string + "IN-ADDR.ARPA.";
            } else if (byArray.length == 16) {
                string = string + "IP6.INT.";
            }
            String[] stringArray = new String[]{"PTR"};
            Map map = this.resolve(this.getTemporaryContext(), string, stringArray);
            Set set = map.entrySet();
            String string2 = "";
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                string2 = (String)((ArrayList)entry.getValue()).get(0);
            }
            return string2;
        }
        catch (Exception exception) {
            throw new UnknownHostException(exception.getMessage());
        }
    }

    private static void appendIfLiteralAddress(String string, StringBuffer stringBuffer) {
        if (DNSNameService.isIPv4LiteralAddress(string)) {
            stringBuffer.append("dns://" + string + " ");
        } else if (DNSNameService.isIPv6LiteralAddress(string)) {
            stringBuffer.append("dns://[" + string + "] ");
        }
    }

    private static String createProviderURL(List list) {
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            DNSNameService.appendIfLiteralAddress((String)iterator.next(), stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static String createProviderURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            DNSNameService.appendIfLiteralAddress(stringTokenizer.nextToken(), stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static boolean isIPv4LiteralAddress(String string) {
        return DNSNameService.textToIPv4Address(string) != null;
    }

    private static boolean isIPv6LiteralAddress(String string) {
        return DNSNameService.textToIPv6Address(string) != null;
    }

    private static byte[] textToIPv4Address(String string) {
        if (string.length() == 0) {
            return null;
        }
        byte[] byArray = new byte[4];
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            char c;
            if (Character.isDigit(c = cArray[n2++])) {
                int n4 = byArray[n3] * 10 + (Character.digit(c, 10) & 0xFF);
                if (n4 > 255) {
                    return null;
                }
                byArray[n3] = (byte)(n4 & 0xFF);
                if (bl) continue;
                if (++n > 4) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (c == '.' && bl) {
                if (n == 4) {
                    return null;
                }
                byArray[++n3] = 0;
                bl = false;
                continue;
            }
            return null;
        }
        if (n < 4) {
            return null;
        }
        return byArray;
    }

    private static byte[] textToIPv6Address(String string) {
        int n;
        if (string.length() == 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[16];
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        if (cArray[n3] == ':' && cArray[++n3] != ':') {
            return null;
        }
        int n5 = n3;
        boolean bl = false;
        int n6 = 0;
        while (n3 < cArray.length) {
            char c;
            if ((n = Character.digit(c = cArray[n3++], 16)) != -1) {
                n6 <<= 4;
                if ((n6 |= n) > 65535) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (c == ':') {
                n5 = n3;
                if (!bl) {
                    if (n2 != -1) {
                        return null;
                    }
                    n2 = n4;
                    continue;
                }
                if (n3 == cArray.length) {
                    return null;
                }
                if (n4 + 2 > 16) {
                    return null;
                }
                byArray[n4++] = (byte)(n6 >> 8 & 0xFF);
                byArray[n4++] = (byte)(n6 & 0xFF);
                bl = false;
                n6 = 0;
                continue;
            }
            if (c == '.' && n4 + 4 <= 16) {
                byte[] byArray2 = DNSNameService.textToIPv4Address(string.substring(n5));
                if (byArray2 == null) {
                    return null;
                }
                int n7 = 0;
                while (n7 < 4) {
                    byArray[n4++] = byArray2[n7];
                    ++n7;
                }
                bl = false;
                break;
            }
            return null;
        }
        if (bl) {
            if (n4 + 2 > 16) {
                return null;
            }
            byArray[n4++] = (byte)(n6 >> 8 & 0xFF);
            byArray[n4++] = (byte)(n6 & 0xFF);
        }
        if (n2 != -1) {
            n = n4 - n2;
            if (n4 == 16) {
                return null;
            }
            n3 = 1;
            while (n3 <= n) {
                byArray[16 - n3] = byArray[n2 + n - n3];
                byArray[n2 + n - n3] = 0;
                ++n3;
            }
            n4 = 16;
        }
        if (n4 != 16) {
            return null;
        }
        return byArray;
    }

    private static class ThreadContext {
        private DirContext dirCtxt;
        private List nsList;

        public ThreadContext(DirContext dirContext, List list) {
            this.dirCtxt = dirContext;
            this.nsList = list;
        }

        public DirContext dirContext() {
            return this.dirCtxt;
        }

        public List nameservers() {
            return this.nsList;
        }
    }
}

