#ifndef KAB3_H
#define KAB3_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kparts/mainwindow.h>

class KToggleAction;

/**
   The KAB MkIII shell.

 * @short KAB MkIII Shell
 * @author Mirko Boehm <mirko@kde.org>
 * @version 3.0
 */
class kab3 : public KParts::MainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    kab3();

    /**
     * Default Destructor
     */
    virtual ~kab3();

    /**
     * Open an address book
     */
    void load(const KURL& url);

protected:
    /**
     * This method is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig *);

    /**
     * This method is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig *);
    /** Overload queryclose .*/
    bool queryClose();
private slots:
    void fileNew();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();

    void applyNewToolbarConfig();

private:
    void setupAccel();
    void setupActions();

private:
    KParts::ReadWritePart *m_part;

    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
};

#endif // KAB3_H
