#ifndef __htmlbugjob_h__
#define __htmlbugjob_h__

#include <qobject.h>

#include <dom/html_document.h>

#include <kparts/browserextension.h>

#include <kio/jobclasses.h>

class KHTMLPart;

class HTMLBugJob : public KIO::Job
{
    Q_OBJECT
public:
    HTMLBugJob();
    virtual ~HTMLBugJob();

signals:
    void infoMessage( const QString &text );
    void infoPercent( unsigned long percent );

protected:
    void start( const KURL &url /*, const KParts::URLArgs &args = KParts::URLArgs()*/ );

    virtual void process() = 0;

    virtual void processFiltered( const QStringList &tags );

    virtual void processNode( const DOM::Node &node );

    DOM::Node m_node;
    KURL m_url;
    
private slots:
    void ioResult( KIO::Job *job );

    void ioData( KIO::Job *job, const QByteArray &data );

    void ioInfoMessage( KIO::Job *job, const QString &text );

    void ioInfoPercent( KIO::Job *job, unsigned long percent );

private:
    KHTMLPart *m_part;
    QString m_data;
};

#endif
/*
 * vim:sw=4:ts=4:et
 */
