#ifndef __buglistjob_h__
#define __buglistjob_h__

#include "htmlbugjob.h"
#include "package.h"
#include "bug.h"

class BugListJob : public HTMLBugJob
{
    Q_OBJECT
public:
    BugListJob();
    virtual ~BugListJob();

    void start( const Package &pkg );

signals:
    void bugListAvailable( const Package &pkg, const Bug::List &bugs );

protected:
    virtual void process();
    virtual void processNode( const DOM::Node &n );

private:
    void parseSeverity( const DOM::Element &e );
    void parseAge( const QString &text, uint &age );

    Package m_package;
    Bug::Severity m_currentSeverity;
    Bug::Status m_currentStatus;
    Bug::List m_bugs; 
};

#endif

/*
 * vim:ts=4:sw=4:et
 */
